package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.License;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for license.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-license</b>
 * <pre>
 * container state {
 *   config false;
 *   uses license-config;
 *   uses license-state;
 * }
 * </pre>
 * <p>To create instances of this class use {@link StateBuilder}.
 * @see StateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface State
    extends
    ChildOf<License>,
    Augmentable<State>,
    LicenseConfig,
    LicenseState
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license.State> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license.State.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license.@NonNull State obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getActive());
        result = prime * result + Objects.hashCode(obj.getDescription());
        result = prime * result + Objects.hashCode(obj.getExpirationDate());
        result = prime * result + Objects.hashCode(obj.getExpired());
        result = prime * result + Objects.hashCode(obj.getInUse());
        result = prime * result + Objects.hashCode(obj.getIssueDate());
        result = prime * result + Objects.hashCode(obj.getLicenseData());
        result = prime * result + Objects.hashCode(obj.getLicenseId());
        result = prime * result + Objects.hashCode(obj.getValid());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license.@NonNull State thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license.State.class, obj);
        return other != null
            && Objects.equals(thisObj.getActive(), other.getActive())
            && Objects.equals(thisObj.getExpirationDate(), other.getExpirationDate())
            && Objects.equals(thisObj.getExpired(), other.getExpired())
            && Objects.equals(thisObj.getInUse(), other.getInUse())
            && Objects.equals(thisObj.getIssueDate(), other.getIssueDate())
            && Objects.equals(thisObj.getValid(), other.getValid())
            && Objects.equals(thisObj.getDescription(), other.getDescription())
            && Objects.equals(thisObj.getLicenseId(), other.getLicenseId())
            && Objects.equals(thisObj.getLicenseData(), other.getLicenseData())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license.@NonNull State obj) {
        final var helper = MoreObjects.toStringHelper("State");
        CodeHelpers.appendValue(helper, "active", obj.getActive());
        CodeHelpers.appendValue(helper, "description", obj.getDescription());
        CodeHelpers.appendValue(helper, "expirationDate", obj.getExpirationDate());
        CodeHelpers.appendValue(helper, "expired", obj.getExpired());
        CodeHelpers.appendValue(helper, "inUse", obj.getInUse());
        CodeHelpers.appendValue(helper, "issueDate", obj.getIssueDate());
        CodeHelpers.appendValue(helper, "licenseData", obj.getLicenseData());
        CodeHelpers.appendValue(helper, "licenseId", obj.getLicenseId());
        CodeHelpers.appendValue(helper, "valid", obj.getValid());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

