package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.aggregation;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.AggregationLogicalConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.AggregationLogicalState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.AggregationType;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Uint32 _lagSpeed;
    private AggregationType _lagType;
    private Set<String> _member;
    private Uint16 _minLinks;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link AggregationLogicalConfig}.
     *
     * @param arg AggregationLogicalConfig from which the builder should be initialized
     */
    public StateBuilder(AggregationLogicalConfig arg) {
        this._lagType = arg.getLagType();
        this._minLinks = arg.getMinLinks();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link AggregationLogicalState}.
     *
     * @param arg AggregationLogicalState from which the builder should be initialized
     */
    public StateBuilder(AggregationLogicalState arg) {
        this._lagSpeed = arg.getLagSpeed();
        this._member = arg.getMember();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._lagSpeed = base.getLagSpeed();
        this._lagType = base.getLagType();
        this._member = base.getMember();
        this._minLinks = base.getMinLinks();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link AggregationLogicalState}</li>
     *   <li>{@link AggregationLogicalConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AggregationLogicalState castArg) {
            this._lagSpeed = castArg.getLagSpeed();
            this._member = castArg.getMember();
            isValidArg = true;
        }
        if (arg instanceof AggregationLogicalConfig castArg) {
            this._lagType = castArg.getLagType();
            this._minLinks = castArg.getMinLinks();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AggregationLogicalState, AggregationLogicalConfig]");
    }

    private static final class LazyEmpty {
        static final @NonNull State INSTANCE = new StateBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of State.
     *
     * @return An empty {@link State}
     */
    public static @NonNull State empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getLagSpeed()}.
     *
     * @return current value
     */
    public Uint32 getLagSpeed() {
        return _lagSpeed;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getLagType()}.
     *
     * @return current value
     */
    public AggregationType getLagType() {
        return _lagType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMember()}.
     *
     * @return current value
     */
    public Set<String> getMember() {
        return _member;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMinLinks()}.
     *
     * @return current value
     */
    public Uint16 getMinLinks() {
        return _minLinks;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getLagSpeed()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setLagSpeed(final Uint32 value) {
        this._lagSpeed = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getLagType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setLagType(final AggregationType value) {
        this._lagType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getMember()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public StateBuilder setMember(final Set<String> values) {
        this._member = values;
        return this;
    }
    
    
    /**
     * Set the property corresponding to {@link State#getMinLinks()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setMinLinks(final Uint16 value) {
        this._minLinks = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Uint32 _lagSpeed;
        private final AggregationType _lagType;
        private final Set<String> _member;
        private final Uint16 _minLinks;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._lagSpeed = base.getLagSpeed();
            this._lagType = base.getLagType();
            this._member = base.getMember();
            this._minLinks = base.getMinLinks();
        }
    
        @Override
        public Uint32 getLagSpeed() {
            return _lagSpeed;
        }
        
        @Override
        public AggregationType getLagType() {
            return _lagType;
        }
        
        @Override
        public Set<String> getMember() {
            return _member;
        }
        
        @Override
        public Uint16 getMinLinks() {
            return _minLinks;
        }
    
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
