package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501.aggregation.logical.top.Aggregation;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level data definitions for LAGs
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-aggregate</b>
 * <pre>
 * grouping aggregation-logical-top {
 *   container aggregation {
 *     container config {
 *       uses aggregation-logical-config;
 *     }
 *     container state {
 *       config false;
 *       uses aggregation-logical-config;
 *       uses aggregation-logical-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AggregationLogicalTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aggregation-logical-top");

    @Override
    Class<? extends AggregationLogicalTop> implementedInterface();
    
    /**
     * Return aggregation, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Options for logical interfaces representing aggregates
     *     </code>
     * </pre>
     *
     * @return {@code Aggregation} aggregation, or {@code null} if it is not present.
     *
     */
    Aggregation getAggregation();
    
    /**
     * Return aggregation, or an empty instance if it is not present.
     *
     * @return {@code Aggregation} aggregation, or an empty instance if it is not present.
     *
     */
    @NonNull Aggregation nonnullAggregation();

}

