package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Configuration data for aggregate interfaces
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-aggregate</b>
 * <pre>
 * grouping aggregation-logical-config {
 *   leaf lag-type {
 *     type aggregation-type;
 *   }
 *   leaf min-links {
 *     type uint16;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AggregationLogicalConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aggregation-logical-config");

    @Override
    Class<? extends AggregationLogicalConfig> implementedInterface();
    
    /**
     * Return lagType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Sets the type of LAG, i.e., how it is configured / maintained
     *     </code>
     * </pre>
     *
     * @return {@code AggregationType} lagType, or {@code null} if it is not present.
     *
     */
    AggregationType getLagType();
    
    /**
     * Return lagType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Sets the type of LAG, i.e., how it is configured / maintained
     *     </code>
     * </pre>
     *
     * @return {@code AggregationType} lagType, guaranteed to be non-null.
     * @throws NoSuchElementException if lagType is not present
     *
     */
    default @NonNull AggregationType requireLagType() {
        return CodeHelpers.require(getLagType(), "lagtype");
    }
    
    /**
     * Return minLinks, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Specifies the mininum number of member interfaces that must be active for the
     *         aggregate interface to be available
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} minLinks, or {@code null} if it is not present.
     *
     */
    Uint16 getMinLinks();
    
    /**
     * Return minLinks, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Specifies the mininum number of member interfaces that must be active for the
     *         aggregate interface to be available
     *     </code>
     * </pre>
     *
     * @return {@code Uint16} minLinks, guaranteed to be non-null.
     * @throws NoSuchElementException if minLinks is not present
     *
     */
    default @NonNull Uint16 requireMinLinks() {
        return CodeHelpers.require(getMinLinks(), "minlinks");
    }

}

