package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.Alarms;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for device alarms
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-alarms</b>
 * <pre>
 * grouping alarms-top {
 *   container alarms {
 *     config false;
 *     list alarm {
 *       key id;
 *       leaf id {
 *         type leafref {
 *           path ../state/id;
 *         }
 *       }
 *       container config {
 *         uses alarm-config;
 *       }
 *       container state {
 *         config false;
 *         uses alarm-config;
 *         uses alarm-state;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AlarmsTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("alarms-top");

    @Override
    Class<? extends AlarmsTop> implementedInterface();
    
    /**
     * Return alarms, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for device alarms
     *     </code>
     * </pre>
     *
     * @return {@code Alarms} alarms, or {@code null} if it is not present.
     *
     */
    Alarms getAlarms();
    
    /**
     * Return alarms, or an empty instance if it is not present.
     *
     * @return {@code Alarms} alarms, or an empty instance if it is not present.
     *
     */
    @NonNull Alarms nonnullAlarms();

}

