package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.Server;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.ServerKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container the list of servers
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * container servers {
 *   list server {
 *     key address;
 *     leaf address {
 *       type leafref {
 *         path ../config/address;
 *       }
 *     }
 *     container config {
 *       uses aaa-server-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-server-config;
 *       uses aaa-server-state;
 *     }
 *     uses aaa-tacacs-server-top {
 *       when "../../config/type = 'oc-aaa:TACACS'";
 *     }
 *     uses aaa-radius-server-top {
 *       when "../../config/type = 'oc-aaa:RADIUS'";
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link ServersBuilder}.
 * @see ServersBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Servers
    extends
    ChildOf<AaaServerTop>,
    Augmentable<Servers>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("servers");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.Servers> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.Servers.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.@NonNull Servers obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getServer());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.@NonNull Servers thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.Servers.class, obj);
        return other != null
            && Objects.equals(thisObj.getServer(), other.getServer())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.@NonNull Servers obj) {
        final var helper = MoreObjects.toStringHelper("Servers");
        CodeHelpers.appendValue(helper, "server", obj.getServer());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return server, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of AAA servers
     *     </code>
     * </pre>
     *
     * @return {@code Map<ServerKey, Server>} server, or {@code null} if it is not present.
     *
     */
    @Nullable Map<ServerKey, Server> getServer();
    
    /**
     * Return server, or an empty list if it is not present.
     *
     * @return {@code Map<ServerKey, Server>} server, or an empty list if it is not present.
     *
     */
    default @NonNull Map<ServerKey, Server> nonnullServer() {
        return CodeHelpers.nonnull(getServer());
    }

}

