package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.servergroup.common.top.ServerGroups;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for AAA server groups
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-servergroup-common-top {
 *   container server-groups {
 *     list server-group {
 *       key name;
 *       leaf name {
 *         type leafref {
 *           path ../config/name;
 *         }
 *       }
 *       container config {
 *         uses aaa-servergroup-common-config;
 *       }
 *       container state {
 *         config false;
 *         uses aaa-servergroup-common-config;
 *         uses aaa-servergroup-common-state;
 *       }
 *       uses aaa-server-top;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaServergroupCommonTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-servergroup-common-top");

    @Override
    Class<? extends AaaServergroupCommonTop> implementedInterface();
    
    /**
     * Return serverGroups, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Enclosing container for AAA server groups
     *     </code>
     * </pre>
     *
     * @return {@code ServerGroups} serverGroups, or {@code null} if it is not present.
     *
     */
    ServerGroups getServerGroups();
    
    /**
     * Return serverGroups, or an empty instance if it is not present.
     *
     * @return {@code ServerGroups} serverGroups, or an empty instance if it is not present.
     *
     */
    @NonNull ServerGroups nonnullServerGroups();

}

