package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for the root user
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-admin-state {
 *   leaf admin-username {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAdminState
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-admin-state");

    @Override
    Class<? extends AaaAdminState> implementedInterface();
    
    /**
     * Return adminUsername, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Name of the administrator user account, e.g., admin, root, etc.
     *     </code>
     * </pre>
     *
     * @return {@code String} adminUsername, or {@code null} if it is not present.
     *
     */
    String getAdminUsername();
    
    /**
     * Return adminUsername, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Name of the administrator user account, e.g., admin, root, etc.
     *     </code>
     * </pre>
     *
     * @return {@code String} adminUsername, guaranteed to be non-null.
     * @throws NoSuchElementException if adminUsername is not present
     *
     */
    default @NonNull String requireAdminUsername() {
        return CodeHelpers.require(getAdminUsername(), "adminusername");
    }

}

