package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.AAAMETHODTYPE;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.UnionTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Common definitions for accounting methods
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-accounting-methods-common {
 *   leaf-list accounting-method {
 *     type union {
 *       type identityref {
 *         base AAA_METHOD_TYPE;
 *       }
 *       type string;
 *     }
 *     ordered-by user;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAccountingMethodsCommon
    extends
    DataObject
{

    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
     * <pre>
     * leaf-list accounting-method {
     *   type union {
     *     type identityref {
     *       base AAA_METHOD_TYPE;
     *     }
     *     type string;
     *   }
     *   ordered-by user;
     * }
     * </pre>
     *
     */
    public static final class AccountingMethod
     implements UnionTypeObject, Serializable {
        @java.io.Serial
        private static final long serialVersionUID = -4582262896493255564L;
        private final AAAMETHODTYPE _aAAMETHODTYPE;
        private final String _string;
    
    
        public AccountingMethod(AAAMETHODTYPE _aAAMETHODTYPE) {
            this._aAAMETHODTYPE = Objects.requireNonNull(_aAAMETHODTYPE);
            this._string = null;
        }
        
        public AccountingMethod(String _string) {
            this._aAAMETHODTYPE = null;
            this._string = Objects.requireNonNull(_string);
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public AccountingMethod(AccountingMethod source) {
            this._aAAMETHODTYPE = source._aAAMETHODTYPE;
            this._string = source._string;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_aAAMETHODTYPE != null) {
                return _aAAMETHODTYPE.implementedInterface().toString();
            }
            if (_string != null) {
                return _string;
            }
            throw new IllegalStateException("No value assigned");
        }
    
    
        public AAAMETHODTYPE getAAAMETHODTYPE() {
            return _aAAMETHODTYPE;
        }
        
        public String getString() {
            return _string;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_aAAMETHODTYPE);
            result = prime * result + Objects.hashCode(_string);
            return result;
        }
    
        @Override
        public final boolean equals(Object obj) {
            return this == obj || obj instanceof AccountingMethod other
                && Objects.equals(_aAAMETHODTYPE, other._aAAMETHODTYPE)        
                && Objects.equals(_string, other._string);
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(AccountingMethod.class);
            CodeHelpers.appendValue(helper, "aAAMETHODTYPE", _aAAMETHODTYPE);
            CodeHelpers.appendValue(helper, "string", _string);
            return helper.toString();
        }
    }
    


    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-accounting-methods-common");

    @Override
    Class<? extends AaaAccountingMethodsCommon> implementedInterface();
    
    /**
     * Return accountingMethod, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         An ordered list of methods used for AAA accounting for this event type. The
     *         method is defined by the destination for accounting data, which may be specified
     *         as the group of all TACACS+/RADIUS servers, a defined server group, or the local
     *         system.
     *     </code>
     * </pre>
     *
     * @return {@code List<AccountingMethod>} accountingMethod, or {@code null} if it is not present.
     *
     */
    @Nullable List<AccountingMethod> getAccountingMethod();
    
    /**
     * Return accountingMethod, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         An ordered list of methods used for AAA accounting for this event type. The
     *         method is defined by the destination for accounting data, which may be specified
     *         as the group of all TACACS+/RADIUS servers, a defined server group, or the local
     *         system.
     *     </code>
     * </pre>
     *
     * @return {@code List<AccountingMethod>} accountingMethod, guaranteed to be non-null.
     * @throws NoSuchElementException if accountingMethod is not present
     *
     */
    default @NonNull List<AccountingMethod> requireAccountingMethod() {
        return CodeHelpers.require(getAccountingMethod(), "accountingmethod");
    }

}

