package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.AAAACCOUNTINGEVENTTYPE;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Configuration data for AAA accounting events
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-accounting-events-config {
 *   leaf event-type {
 *     type identityref {
 *       base AAA_ACCOUNTING_EVENT_TYPE;
 *     }
 *   }
 *   leaf record {
 *     type enumeration {
 *       enum START_STOP {
 *       }
 *       enum STOP {
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaAccountingEventsConfig
    extends
    DataObject
{


    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
     * <pre>
     * leaf record {
     *   type enumeration {
     *     enum START_STOP {
     *     }
     *     enum STOP {
     *     }
     *   }
     * }
     * </pre>
     *
     */
    @Generated("mdsal-binding-generator")
    public enum Record implements EnumTypeObject {
        /**
         * Send START record to the accounting server at the
         * beginning of the activity, and STOP record at the
         * end of the activity.
         */
        STARTSTOP(0, "START_STOP"),
        
        /**
         * Send STOP record to the accounting server when the
         * user activity completes
         */
        STOP(1, "STOP")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private Record(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding Record item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable Record forName(String name) {
            return switch (name) {
                case "START_STOP" -> STARTSTOP;
                case "STOP" -> STOP;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Record item, or {@code null} if no such item exists
         */
        public static @Nullable Record forValue(int intValue) {
            return switch (intValue) {
                case 0 -> STARTSTOP;
                case 1 -> STOP;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding Record item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull Record ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Record item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull Record ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-accounting-events-config");

    @Override
    Class<? extends AaaAccountingEventsConfig> implementedInterface();
    
    /**
     * Return eventType, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The type of activity to record at the AAA accounting server
     *     </code>
     * </pre>
     *
     * @return {@code AAAACCOUNTINGEVENTTYPE} eventType, or {@code null} if it is not present.
     *
     */
    AAAACCOUNTINGEVENTTYPE getEventType();
    
    /**
     * Return eventType, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The type of activity to record at the AAA accounting server
     *     </code>
     * </pre>
     *
     * @return {@code AAAACCOUNTINGEVENTTYPE} eventType, guaranteed to be non-null.
     * @throws NoSuchElementException if eventType is not present
     *
     */
    default @NonNull AAAACCOUNTINGEVENTTYPE requireEventType() {
        return CodeHelpers.require(getEventType(), "eventtype");
    }
    
    /**
     * Return record, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Type of record to send to the accounting server for this activity type
     *     </code>
     * </pre>
     *
     * @return {@code Record} record, or {@code null} if it is not present.
     *
     */
    Record getRecord();
    
    /**
     * Return record, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Type of record to send to the accounting server for this activity type
     *     </code>
     * </pre>
     *
     * @return {@code Record} record, guaranteed to be non-null.
     * @throws NoSuchElementException if record is not present
     *
     */
    default @NonNull Record requireRecord() {
        return CodeHelpers.require(getRecord(), "record");
    }

}

