/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107;

import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.util.Objects;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class Ipv6FlowLabel
implements ScalarTypeObject<Uint32>,
Serializable {
    private static final long serialVersionUID = -7589288865525379836L;
    private final Uint32 _value;

    private static void check_valueRange(long value) {
        if (value <= 1048575L) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..1048575]]", (long)value);
    }

    @ConstructorParameters(value={"value"})
    public Ipv6FlowLabel(Uint32 _value) {
        if (_value != null) {
            Ipv6FlowLabel.check_valueRange(_value.longValue());
        }
        CodeHelpers.requireValue((Object)_value);
        this._value = _value;
    }

    public Ipv6FlowLabel(Ipv6FlowLabel source) {
        this._value = source._value;
    }

    public static Ipv6FlowLabel getDefaultInstance(String defaultValue) {
        return new Ipv6FlowLabel(Uint32.valueOf((String)defaultValue));
    }

    public Uint32 getValue() {
        return this._value;
    }

    public int hashCode() {
        return CodeHelpers.wrapperHashCode((Object)this._value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof Ipv6FlowLabel)) return false;
        Ipv6FlowLabel other = (Ipv6FlowLabel)obj;
        if (!Objects.equals(this._value, other._value)) return false;
        return true;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Ipv6FlowLabel.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"value", (Object)this._value);
        return helper.toString();
    }
}

