/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.Process;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.ProcessKey;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.processes.process.StateBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint64;

public class ProcessBuilder {
    private Uint64 _pid;
    private State _state;
    private ProcessKey key;
    Map<Class<? extends Augmentation<Process>>, Augmentation<Process>> augmentation = Map.of();

    public ProcessBuilder() {
    }

    public ProcessBuilder(Process base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Process>>, Augmentation<Process>>(aug);
        }
        this.key = base.key();
        this._pid = base.getPid();
        this._state = base.getState();
    }

    public ProcessKey key() {
        return this.key;
    }

    public Uint64 getPid() {
        return this._pid;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Process>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ProcessBuilder withKey(ProcessKey key) {
        this.key = key;
        return this;
    }

    public ProcessBuilder setPid(Uint64 value) {
        this._pid = value;
        return this;
    }

    public ProcessBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ProcessBuilder addAugmentation(Augmentation<Process> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Process>>, Augmentation<Process>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ProcessBuilder removeAugmentation(Class<? extends Augmentation<Process>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Process build() {
        return new ProcessImpl(this);
    }

    private static final class ProcessImpl
    extends AbstractAugmentable<Process>
    implements Process {
        private final Uint64 _pid;
        private final State _state;
        private final ProcessKey key;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ProcessImpl(ProcessBuilder base) {
            super(base.augmentation);
            this.key = base.key() != null ? base.key() : new ProcessKey(base.getPid());
            this._pid = this.key.getPid();
            this._state = base.getState();
        }

        @Override
        public ProcessKey key() {
            return this.key;
        }

        @Override
        public Uint64 getPid() {
            return this._pid;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(this.getState(), StateBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Process.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Process.bindingEquals(this, obj);
        }

        public String toString() {
            return Process.bindingToString(this);
        }
    }
}

