/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.Chassis;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.chassis.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.chassis.ConfigBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.chassis.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.anchors.top.chassis.StateBuilder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

public class ChassisBuilder {
    private Config _config;
    private State _state;
    Map<Class<? extends Augmentation<Chassis>>, Augmentation<Chassis>> augmentation = Map.of();

    public ChassisBuilder() {
    }

    public ChassisBuilder(Chassis base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Chassis>>, Augmentation<Chassis>>(aug);
        }
        this._config = base.getConfig();
        this._state = base.getState();
    }

    public static @NonNull Chassis empty() {
        return LazyEmpty.INSTANCE;
    }

    public Config getConfig() {
        return this._config;
    }

    public State getState() {
        return this._state;
    }

    public <E$$ extends Augmentation<Chassis>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ChassisBuilder setConfig(Config value) {
        this._config = value;
        return this;
    }

    public ChassisBuilder setState(State value) {
        this._state = value;
        return this;
    }

    public ChassisBuilder addAugmentation(Augmentation<Chassis> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Chassis>>, Augmentation<Chassis>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ChassisBuilder removeAugmentation(Class<? extends Augmentation<Chassis>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Chassis build() {
        return new ChassisImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Chassis INSTANCE = new ChassisBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ChassisImpl
    extends AbstractAugmentable<Chassis>
    implements Chassis {
        private final Config _config;
        private final State _state;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ChassisImpl(ChassisBuilder base) {
            super(base.augmentation);
            this._config = base.getConfig();
            this._state = base.getState();
        }

        @Override
        public Config getConfig() {
            return this._config;
        }

        @Override
        public State getState() {
            return this._state;
        }

        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(this.getConfig(), ConfigBuilder.empty());
        }

        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(this.getState(), StateBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Chassis.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Chassis.bindingEquals(this, obj);
        }

        public String toString() {
            return Chassis.bindingToString(this);
        }
    }
}

