/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.top.messages;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.MessagesConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.MessagesState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state.Message;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state.MessageBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.top.messages.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SyslogSeverity;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class StateBuilder {
    private Message _message;
    private SyslogSeverity _severity;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(MessagesConfig arg) {
        this._severity = arg.getSeverity();
    }

    public StateBuilder(MessagesState arg) {
        this._message = arg.getMessage();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._message = base.getMessage();
        this._severity = base.getSeverity();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof MessagesConfig) {
            castArg = (MessagesConfig)arg;
            this._severity = castArg.getSeverity();
            isValidArg = true;
        }
        if (arg instanceof MessagesState) {
            castArg = (MessagesState)arg;
            this._message = castArg.getMessage();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[MessagesConfig, MessagesState]");
    }

    public static @NonNull State empty() {
        return LazyEmpty.INSTANCE;
    }

    public Message getMessage() {
        return this._message;
    }

    public SyslogSeverity getSeverity() {
        return this._severity;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setMessage(Message value) {
        this._message = value;
        return this;
    }

    public StateBuilder setSeverity(SyslogSeverity value) {
        this._severity = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull State INSTANCE = new StateBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final Message _message;
        private final SyslogSeverity _severity;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._message = base.getMessage();
            this._severity = base.getSeverity();
        }

        @Override
        public Message getMessage() {
            return this._message;
        }

        @Override
        public SyslogSeverity getSeverity() {
            return this._severity;
        }

        @Override
        public Message nonnullMessage() {
            return Objects.requireNonNullElse(this.getMessage(), MessageBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

