/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces.subinterface;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCommonState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.InterfaceCountersState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.SubinterfacesConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.SubinterfacesState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406._interface.counters.state.Counters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406._interface.counters.state.CountersBuilder;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.rev210406.subinterfaces.top.subinterfaces.subinterface.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.Timeticks64;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint32;

public class StateBuilder {
    private InterfaceCommonState.AdminStatus _adminStatus;
    private Counters _counters;
    private Boolean _cpu;
    private String _description;
    private Boolean _enabled;
    private Uint32 _ifindex;
    private Uint32 _index;
    private Timeticks64 _lastChange;
    private Boolean _logical;
    private Boolean _management;
    private String _name;
    private InterfaceCommonState.OperStatus _operStatus;
    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    public StateBuilder() {
    }

    public StateBuilder(SubinterfacesConfig arg) {
        this._index = arg.getIndex();
        this._description = arg.getDescription();
        this._enabled = arg.getEnabled();
    }

    public StateBuilder(InterfaceCommonConfig arg) {
        this._description = arg.getDescription();
        this._enabled = arg.getEnabled();
    }

    public StateBuilder(SubinterfacesState arg) {
        this._name = arg.getName();
        this._ifindex = arg.getIfindex();
        this._adminStatus = arg.getAdminStatus();
        this._operStatus = arg.getOperStatus();
        this._lastChange = arg.getLastChange();
        this._logical = arg.getLogical();
        this._management = arg.getManagement();
        this._cpu = arg.getCpu();
        this._counters = arg.getCounters();
    }

    public StateBuilder(InterfaceCommonState arg) {
        this._ifindex = arg.getIfindex();
        this._adminStatus = arg.getAdminStatus();
        this._operStatus = arg.getOperStatus();
        this._lastChange = arg.getLastChange();
        this._logical = arg.getLogical();
        this._management = arg.getManagement();
        this._cpu = arg.getCpu();
    }

    public StateBuilder(InterfaceCountersState arg) {
        this._counters = arg.getCounters();
    }

    public StateBuilder(State base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>(aug);
        }
        this._adminStatus = base.getAdminStatus();
        this._counters = base.getCounters();
        this._cpu = base.getCpu();
        this._description = base.getDescription();
        this._enabled = base.getEnabled();
        this._ifindex = base.getIfindex();
        this._index = base.getIndex();
        this._lastChange = base.getLastChange();
        this._logical = base.getLogical();
        this._management = base.getManagement();
        this._name = base.getName();
        this._operStatus = base.getOperStatus();
    }

    public void fieldsFrom(DataObject arg) {
        Object castArg;
        boolean isValidArg = false;
        if (arg instanceof SubinterfacesConfig) {
            castArg = (SubinterfacesConfig)arg;
            this._index = castArg.getIndex();
            isValidArg = true;
        }
        if (arg instanceof SubinterfacesState) {
            castArg = (SubinterfacesState)arg;
            this._name = castArg.getName();
            isValidArg = true;
        }
        if (arg instanceof InterfaceCommonState) {
            castArg = (InterfaceCommonState)arg;
            this._ifindex = castArg.getIfindex();
            this._adminStatus = castArg.getAdminStatus();
            this._operStatus = castArg.getOperStatus();
            this._lastChange = castArg.getLastChange();
            this._logical = castArg.getLogical();
            this._management = castArg.getManagement();
            this._cpu = castArg.getCpu();
            isValidArg = true;
        }
        if (arg instanceof InterfaceCommonConfig) {
            castArg = (InterfaceCommonConfig)arg;
            this._description = castArg.getDescription();
            this._enabled = castArg.getEnabled();
            isValidArg = true;
        }
        if (arg instanceof InterfaceCountersState) {
            castArg = (InterfaceCountersState)arg;
            this._counters = castArg.getCounters();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SubinterfacesConfig, SubinterfacesState, InterfaceCommonState, InterfaceCommonConfig, InterfaceCountersState]");
    }

    public static @NonNull State empty() {
        return LazyEmpty.INSTANCE;
    }

    public InterfaceCommonState.AdminStatus getAdminStatus() {
        return this._adminStatus;
    }

    public Counters getCounters() {
        return this._counters;
    }

    public Boolean getCpu() {
        return this._cpu;
    }

    public String getDescription() {
        return this._description;
    }

    public Boolean getEnabled() {
        return this._enabled;
    }

    public Uint32 getIfindex() {
        return this._ifindex;
    }

    public Uint32 getIndex() {
        return this._index;
    }

    public Timeticks64 getLastChange() {
        return this._lastChange;
    }

    public Boolean getLogical() {
        return this._logical;
    }

    public Boolean getManagement() {
        return this._management;
    }

    public String getName() {
        return this._name;
    }

    public InterfaceCommonState.OperStatus getOperStatus() {
        return this._operStatus;
    }

    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public StateBuilder setAdminStatus(InterfaceCommonState.AdminStatus value) {
        this._adminStatus = value;
        return this;
    }

    public StateBuilder setCounters(Counters value) {
        this._counters = value;
        return this;
    }

    public StateBuilder setCpu(Boolean value) {
        this._cpu = value;
        return this;
    }

    public StateBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public StateBuilder setEnabled(Boolean value) {
        this._enabled = value;
        return this;
    }

    public StateBuilder setIfindex(Uint32 value) {
        this._ifindex = value;
        return this;
    }

    public StateBuilder setIndex(Uint32 value) {
        this._index = value;
        return this;
    }

    public StateBuilder setLastChange(Timeticks64 value) {
        this._lastChange = value;
        return this;
    }

    public StateBuilder setLogical(Boolean value) {
        this._logical = value;
        return this;
    }

    public StateBuilder setManagement(Boolean value) {
        this._management = value;
        return this;
    }

    public StateBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public StateBuilder setOperStatus(InterfaceCommonState.OperStatus value) {
        this._operStatus = value;
        return this;
    }

    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<State>>, Augmentation<State>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull State INSTANCE = new StateBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class StateImpl
    extends AbstractAugmentable<State>
    implements State {
        private final InterfaceCommonState.AdminStatus _adminStatus;
        private final Counters _counters;
        private final Boolean _cpu;
        private final String _description;
        private final Boolean _enabled;
        private final Uint32 _ifindex;
        private final Uint32 _index;
        private final Timeticks64 _lastChange;
        private final Boolean _logical;
        private final Boolean _management;
        private final String _name;
        private final InterfaceCommonState.OperStatus _operStatus;
        private int hash = 0;
        private volatile boolean hashValid = false;

        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._adminStatus = base.getAdminStatus();
            this._counters = base.getCounters();
            this._cpu = base.getCpu();
            this._description = base.getDescription();
            this._enabled = base.getEnabled();
            this._ifindex = base.getIfindex();
            this._index = base.getIndex();
            this._lastChange = base.getLastChange();
            this._logical = base.getLogical();
            this._management = base.getManagement();
            this._name = base.getName();
            this._operStatus = base.getOperStatus();
        }

        @Override
        public InterfaceCommonState.AdminStatus getAdminStatus() {
            return this._adminStatus;
        }

        @Override
        public Counters getCounters() {
            return this._counters;
        }

        @Override
        public Boolean getCpu() {
            return this._cpu;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public Boolean getEnabled() {
            return this._enabled;
        }

        @Override
        public Uint32 getIfindex() {
            return this._ifindex;
        }

        @Override
        public Uint32 getIndex() {
            return this._index;
        }

        @Override
        public Timeticks64 getLastChange() {
            return this._lastChange;
        }

        @Override
        public Boolean getLogical() {
            return this._logical;
        }

        @Override
        public Boolean getManagement() {
            return this._management;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public InterfaceCommonState.OperStatus getOperStatus() {
            return this._operStatus;
        }

        @Override
        public Counters nonnullCounters() {
            return Objects.requireNonNullElse(this.getCounters(), CountersBuilder.empty());
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = State.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }

        public String toString() {
            return State.bindingToString(this);
        }
    }
}

