/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.top.radius;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaRadiusServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.top.radius.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.types.rev181121.CryptPasswordType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openconfig.types.rev190416.RoutingPassword;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class ConfigBuilder {
    private PortNumber _acctPort;
    private PortNumber _authPort;
    private Uint8 _retransmitAttempts;
    private RoutingPassword _secretKey;
    private CryptPasswordType _secretKeyHashed;
    private IpAddress _sourceAddress;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(AaaRadiusServerConfig arg) {
        this._authPort = arg.getAuthPort();
        this._acctPort = arg.getAcctPort();
        this._secretKey = arg.getSecretKey();
        this._secretKeyHashed = arg.getSecretKeyHashed();
        this._sourceAddress = arg.getSourceAddress();
        this._retransmitAttempts = arg.getRetransmitAttempts();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._acctPort = base.getAcctPort();
        this._authPort = base.getAuthPort();
        this._retransmitAttempts = base.getRetransmitAttempts();
        this._secretKey = base.getSecretKey();
        this._secretKeyHashed = base.getSecretKeyHashed();
        this._sourceAddress = base.getSourceAddress();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaRadiusServerConfig) {
            AaaRadiusServerConfig castArg = (AaaRadiusServerConfig)arg;
            this._authPort = castArg.getAuthPort();
            this._acctPort = castArg.getAcctPort();
            this._secretKey = castArg.getSecretKey();
            this._secretKeyHashed = castArg.getSecretKeyHashed();
            this._sourceAddress = castArg.getSourceAddress();
            this._retransmitAttempts = castArg.getRetransmitAttempts();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[AaaRadiusServerConfig]");
    }

    public static @NonNull Config empty() {
        return LazyEmpty.INSTANCE;
    }

    public PortNumber getAcctPort() {
        return this._acctPort;
    }

    public PortNumber getAuthPort() {
        return this._authPort;
    }

    public Uint8 getRetransmitAttempts() {
        return this._retransmitAttempts;
    }

    public RoutingPassword getSecretKey() {
        return this._secretKey;
    }

    public CryptPasswordType getSecretKeyHashed() {
        return this._secretKeyHashed;
    }

    public IpAddress getSourceAddress() {
        return this._sourceAddress;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setAcctPort(PortNumber value) {
        this._acctPort = value;
        return this;
    }

    public ConfigBuilder setAuthPort(PortNumber value) {
        this._authPort = value;
        return this;
    }

    public ConfigBuilder setRetransmitAttempts(Uint8 value) {
        this._retransmitAttempts = value;
        return this;
    }

    public ConfigBuilder setSecretKey(RoutingPassword value) {
        this._secretKey = value;
        return this;
    }

    public ConfigBuilder setSecretKeyHashed(CryptPasswordType value) {
        this._secretKeyHashed = value;
        return this;
    }

    public ConfigBuilder setSourceAddress(IpAddress value) {
        this._sourceAddress = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class LazyEmpty {
        static final @NonNull Config INSTANCE = new ConfigBuilder().build();

        private LazyEmpty() {
        }
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final PortNumber _acctPort;
        private final PortNumber _authPort;
        private final Uint8 _retransmitAttempts;
        private final RoutingPassword _secretKey;
        private final CryptPasswordType _secretKeyHashed;
        private final IpAddress _sourceAddress;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._acctPort = base.getAcctPort();
            this._authPort = base.getAuthPort();
            this._retransmitAttempts = base.getRetransmitAttempts();
            this._secretKey = base.getSecretKey();
            this._secretKeyHashed = base.getSecretKeyHashed();
            this._sourceAddress = base.getSourceAddress();
        }

        @Override
        public PortNumber getAcctPort() {
            return this._acctPort;
        }

        @Override
        public PortNumber getAuthPort() {
            return this._authPort;
        }

        @Override
        public Uint8 getRetransmitAttempts() {
            return this._retransmitAttempts;
        }

        @Override
        public RoutingPassword getSecretKey() {
            return this._secretKey;
        }

        @Override
        public CryptPasswordType getSecretKeyHashed() {
            return this._secretKeyHashed;
        }

        @Override
        public IpAddress getSourceAddress() {
            return this._sourceAddress;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

