package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.TPIDTYPES;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * TPID configuration for dot1q-enabled interfaces
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-tpid-config {
 *   leaf tpid {
 *     type identityref {
 *       base TPID_TYPES;
 *     }
 *     default oc-vlan-types:TPID_0X8100;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanTpidConfig
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-tpid-config");

    @Override
    Class<? extends VlanTpidConfig> implementedInterface();
    
    /**
     * Return tpid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Optionally set the tag protocol identifier field (TPID) that is accepted on the
     *         VLAN
     *     </code>
     * </pre>
     *
     * @return {@code TPIDTYPES} tpid, or {@code null} if it is not present.
     *
     */
    TPIDTYPES getTpid();
    
    /**
     * Return tpid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Optionally set the tag protocol identifier field (TPID) that is accepted on the
     *         VLAN
     *     </code>
     * </pre>
     *
     * @return {@code TPIDTYPES} tpid, guaranteed to be non-null.
     * @throws NoSuchElementException if tpid is not present
     *
     */
    default @NonNull TPIDTYPES requireTpid() {
        return CodeHelpers.require(getTpid(), "tpid");
    }

}

