package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * VLAN configuration container.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-config {
 *   leaf vlan-id {
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf name {
 *     type string;
 *   }
 *   leaf status {
 *     type enumeration {
 *       enum ACTIVE {
 *       }
 *       enum SUSPENDED {
 *       }
 *     }
 *     default ACTIVE;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanConfig
    extends
    DataObject
{


    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
     * <pre>
     * leaf status {
     *   type enumeration {
     *     enum ACTIVE {
     *     }
     *     enum SUSPENDED {
     *     }
     *   }
     *   default ACTIVE;
     * }
     * </pre>
     *
     */
    @Generated("mdsal-binding-generator")
    public enum Status implements EnumTypeObject {
        /**
         * VLAN is active
         */
        ACTIVE(0, "ACTIVE"),
        
        /**
         * VLAN is inactive / suspended
         */
        SUSPENDED(1, "SUSPENDED")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private Status(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding Status item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable Status forName(String name) {
            return switch (name) {
                case "ACTIVE" -> ACTIVE;
                case "SUSPENDED" -> SUSPENDED;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Status item, or {@code null} if no such item exists
         */
        public static @Nullable Status forValue(int intValue) {
            return switch (intValue) {
                case 0 -> ACTIVE;
                case 1 -> SUSPENDED;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding Status item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull Status ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding Status item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull Status ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-config");

    @Override
    Class<? extends VlanConfig> implementedInterface();
    
    /**
     * Return vlanId, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Interface VLAN id.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, or {@code null} if it is not present.
     *
     */
    VlanId getVlanId();
    
    /**
     * Return vlanId, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Interface VLAN id.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} vlanId, guaranteed to be non-null.
     * @throws NoSuchElementException if vlanId is not present
     *
     */
    default @NonNull VlanId requireVlanId() {
        return CodeHelpers.require(getVlanId(), "vlanid");
    }
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Interface VLAN name.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Interface VLAN name.
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return status, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Admin state of the VLAN
     *     </code>
     * </pre>
     *
     * @return {@code Status} status, or {@code null} if it is not present.
     *
     */
    Status getStatus();
    
    /**
     * Return status, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Admin state of the VLAN
     *     </code>
     * </pre>
     *
     * @return {@code Status} status, guaranteed to be non-null.
     * @throws NoSuchElementException if status is not present
     *
     */
    default @NonNull Status requireStatus() {
        return CodeHelpers.require(getStatus(), "status");
    }

}

