package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.telnet.server;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemTelnetServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemTelnetServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.TelnetServer;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Operational state data for telnet
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-terminal</b>
 * <pre>
 * container state {
 *   config false;
 *   uses system-telnet-server-config;
 *   uses system-telnet-server-state;
 * }
 * </pre>
 * <p>To create instances of this class use {@link StateBuilder}.
 * @see StateBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface State
    extends
    ChildOf<TelnetServer>,
    Augmentable<State>,
    SystemTelnetServerConfig,
    SystemTelnetServerState
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("state");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.telnet.server.State> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.telnet.server.State.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.telnet.server.@NonNull State obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getEnable());
        result = prime * result + Objects.hashCode(obj.getRateLimit());
        result = prime * result + Objects.hashCode(obj.getSessionLimit());
        result = prime * result + Objects.hashCode(obj.getTimeout());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.telnet.server.@NonNull State thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.telnet.server.State.class, obj);
        return other != null
            && Objects.equals(thisObj.getEnable(), other.getEnable())
            && Objects.equals(thisObj.getRateLimit(), other.getRateLimit())
            && Objects.equals(thisObj.getSessionLimit(), other.getSessionLimit())
            && Objects.equals(thisObj.getTimeout(), other.getTimeout())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.telnet.server.@NonNull State obj) {
        final var helper = MoreObjects.toStringHelper("State");
        CodeHelpers.appendValue(helper, "enable", obj.getEnable());
        CodeHelpers.appendValue(helper, "rateLimit", obj.getRateLimit());
        CodeHelpers.appendValue(helper, "sessionLimit", obj.getSessionLimit());
        CodeHelpers.appendValue(helper, "timeout", obj.getTimeout());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }

}

