package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.TelnetServer;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for telnet server 
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system-terminal</b>
 * <pre>
 * grouping system-telnet-server-top {
 *   container telnet-server {
 *     container config {
 *       uses system-telnet-server-config;
 *     }
 *     container state {
 *       config false;
 *       uses system-telnet-server-config;
 *       uses system-telnet-server-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface SystemTelnetServerTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("system-telnet-server-top");

    @Override
    Class<? extends SystemTelnetServerTop> implementedInterface();
    
    /**
     * Return telnetServer, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for telnet terminal servers
     *     </code>
     * </pre>
     *
     * @return {@code TelnetServer} telnetServer, or {@code null} if it is not present.
     *
     */
    TelnetServer getTelnetServer();
    
    /**
     * Return telnetServer, or an empty instance if it is not present.
     *
     * @return {@code TelnetServer} telnetServer, or an empty instance if it is not present.
     *
     */
    @NonNull TelnetServer nonnullTelnetServer();

}

