package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuState.Index;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.Cpus;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.cpu.State;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.Identifiable;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * List of CPU cores on the system (including logical CPUs on hyperthreaded 
 * systems), keyed by either a numerical index, or the ALL value for an entry 
 * representing the aggregation across all CPUs.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-system</b>
 * <pre>
 * list cpu {
 *   key index;
 *   leaf index {
 *     type leafref {
 *       path ../state/index;
 *     }
 *   }
 *   container state {
 *     uses system-cpu-state;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link CpuBuilder}.
 * @see CpuBuilder
 * @see CpuKey
 *
 */
@Generated("mdsal-binding-generator")
public interface Cpu
    extends
    ChildOf<Cpus>,
    Augmentable<Cpu>,
    Identifiable<CpuKey>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("cpu");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.Cpu> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.Cpu.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.@NonNull Cpu obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getIndex());
        result = prime * result + Objects.hashCode(obj.getState());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.@NonNull Cpu thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.Cpu.class, obj);
        return other != null
            && Objects.equals(thisObj.getIndex(), other.getIndex())
            && Objects.equals(thisObj.getState(), other.getState())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.@NonNull Cpu obj) {
        final var helper = MoreObjects.toStringHelper("Cpu");
        CodeHelpers.appendValue(helper, "index", obj.getIndex());
        CodeHelpers.appendValue(helper, "state", obj.getState());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    @Override
    CpuKey key();
    
    /**
     * Return index, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Reference to list key
     *     </code>
     * </pre>
     *
     * @return {@code Index} index, or {@code null} if it is not present.
     *
     */
    Index getIndex();
    
    /**
     * Return index, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Reference to list key
     *     </code>
     * </pre>
     *
     * @return {@code Index} index, guaranteed to be non-null.
     * @throws NoSuchElementException if index is not present
     *
     */
    default @NonNull Index requireIndex() {
        return CodeHelpers.require(getIndex(), "index");
    }
    
    /**
     * Return state, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Operational state data for the system CPU(s)
     *     </code>
     * </pre>
     *
     * @return {@code State} state, or {@code null} if it is not present.
     *
     */
    State getState();
    
    /**
     * Return state, or an empty instance if it is not present.
     *
     * @return {@code State} state, or an empty instance if it is not present.
     *
     */
    @NonNull State nonnullState();

}

