package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.Cpu;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.cpus.CpuKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link Cpus} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Cpus createCpus(int fooXyzzy, int barBaz) {
 *         return new CpusBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Cpus, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Cpus
 *
 */
@Generated("mdsal-binding-generator")
public class CpusBuilder {

    private Map<CpuKey, Cpu> _cpu;


    Map<Class<? extends Augmentation<Cpus>>, Augmentation<Cpus>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public CpusBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Cpus}.
     *
     * @param base Cpus from which the builder should be initialized
     */
    public CpusBuilder(Cpus base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._cpu = base.getCpu();
    }


    private static final class LazyEmpty {
        static final @NonNull Cpus INSTANCE = new CpusBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Cpus.
     *
     * @return An empty {@link Cpus}
     */
    public static @NonNull Cpus empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Cpus#getCpu()}.
     *
     * @return current value
     */
    public Map<CpuKey, Cpu> getCpu() {
        return _cpu;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Cpus>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Cpus#getCpu()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public CpusBuilder setCpu(final Map<CpuKey, Cpu> values) {
        this._cpu = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public CpusBuilder addAugmentation(Augmentation<Cpus> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public CpusBuilder removeAugmentation(Class<? extends Augmentation<Cpus>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Cpus} instance.
     *
     * @return A new {@link Cpus} instance.
     */
    public @NonNull Cpus build() {
        return new CpusImpl(this);
    }

    private static final class CpusImpl
        extends AbstractAugmentable<Cpus>
        implements Cpus {
    
        private final Map<CpuKey, Cpu> _cpu;
    
        CpusImpl(CpusBuilder base) {
            super(base.augmentation);
            this._cpu = CodeHelpers.emptyToNull(base.getCpu());
        }
    
        @Override
        public Map<CpuKey, Cpu> getCpu() {
            return _cpu;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Cpus.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Cpus.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Cpus.bindingToString(this);
        }
    }
}
