package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SYSLOGFACILITY;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.SyslogSeverity;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Selector} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Selector createSelector(int fooXyzzy, int barBaz) {
 *         return new SelectorBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Selector, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Selector
 *
 */
@Generated("mdsal-binding-generator")
public class SelectorBuilder {

    private Config _config;
    private SYSLOGFACILITY _facility;
    private SyslogSeverity _severity;
    private State _state;
    private SelectorKey key;


    Map<Class<? extends Augmentation<Selector>>, Augmentation<Selector>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SelectorBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link Selector}.
     *
     * @param base Selector from which the builder should be initialized
     */
    public SelectorBuilder(Selector base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._facility = base.getFacility();
        this._severity = base.getSeverity();
        this._config = base.getConfig();
        this._state = base.getState();
    }



    /**
     * Return current value associated with the property corresponding to {@link Selector#key()}.
     *
     * @return current value
     */
    public SelectorKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Selector#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Selector#getFacility()}.
     *
     * @return current value
     */
    public SYSLOGFACILITY getFacility() {
        return _facility;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Selector#getSeverity()}.
     *
     * @return current value
     */
    public SyslogSeverity getSeverity() {
        return _severity;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Selector#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Selector>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Selector#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public SelectorBuilder withKey(final SelectorKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Selector#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SelectorBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Selector#getFacility()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SelectorBuilder setFacility(final SYSLOGFACILITY value) {
        this._facility = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Selector#getSeverity()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SelectorBuilder setSeverity(final SyslogSeverity value) {
        this._severity = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Selector#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SelectorBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SelectorBuilder addAugmentation(Augmentation<Selector> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SelectorBuilder removeAugmentation(Class<? extends Augmentation<Selector>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Selector} instance.
     *
     * @return A new {@link Selector} instance.
     */
    public @NonNull Selector build() {
        return new SelectorImpl(this);
    }

    private static final class SelectorImpl
        extends AbstractAugmentable<Selector>
        implements Selector {
    
        private final Config _config;
        private final SYSLOGFACILITY _facility;
        private final SyslogSeverity _severity;
        private final State _state;
        private final SelectorKey key;
    
        SelectorImpl(SelectorBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new SelectorKey(base.getFacility(), base.getSeverity());
            }
            this._facility = key.getFacility();
            this._severity = key.getSeverity();
            this._config = base.getConfig();
            this._state = base.getState();
        }
    
        @Override
        public SelectorKey key() {
            return key;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public SYSLOGFACILITY getFacility() {
            return _facility;
        }
        
        @Override
        public SyslogSeverity getSeverity() {
            return _severity;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(getConfig(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector.ConfigBuilder.empty());
        }
        
        
        
        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(getState(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.selector.StateBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Selector.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Selector.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Selector.bindingToString(this);
        }
    }
}
