package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.Selector;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.selectors.top.selectors.SelectorKey;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

/**
 * Class that builds {@link Selectors} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Selectors createSelectors(int fooXyzzy, int barBaz) {
 *         return new SelectorsBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Selectors, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Selectors
 *
 */
@Generated("mdsal-binding-generator")
public class SelectorsBuilder {

    private Map<SelectorKey, Selector> _selector;


    Map<Class<? extends Augmentation<Selectors>>, Augmentation<Selectors>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SelectorsBuilder() {
        // No-op
    }

    

    /**
     * Construct a builder initialized with state from specified {@link Selectors}.
     *
     * @param base Selectors from which the builder should be initialized
     */
    public SelectorsBuilder(Selectors base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._selector = base.getSelector();
    }


    private static final class LazyEmpty {
        static final @NonNull Selectors INSTANCE = new SelectorsBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of Selectors.
     *
     * @return An empty {@link Selectors}
     */
    public static @NonNull Selectors empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link Selectors#getSelector()}.
     *
     * @return current value
     */
    public Map<SelectorKey, Selector> getSelector() {
        return _selector;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Selectors>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Selectors#getSelector()} to the specified
     * value.
     *
     * @param values desired value
     * @return this builder
     */
    public SelectorsBuilder setSelector(final Map<SelectorKey, Selector> values) {
        this._selector = values;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SelectorsBuilder addAugmentation(Augmentation<Selectors> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SelectorsBuilder removeAugmentation(Class<? extends Augmentation<Selectors>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Selectors} instance.
     *
     * @return A new {@link Selectors} instance.
     */
    public @NonNull Selectors build() {
        return new SelectorsImpl(this);
    }

    private static final class SelectorsImpl
        extends AbstractAugmentable<Selectors>
        implements Selectors {
    
        private final Map<SelectorKey, Selector> _selector;
    
        SelectorsImpl(SelectorsBuilder base) {
            super(base.augmentation);
            this._selector = CodeHelpers.emptyToNull(base.getSelector());
        }
    
        @Override
        public Map<SelectorKey, Selector> getSelector() {
            return _selector;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Selectors.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Selectors.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Selectors.bindingToString(this);
        }
    }
}
