package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents.subcomponent.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents.subcomponent.State;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;

/**
 * Class that builds {@link Subcomponent} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Subcomponent createSubcomponent(int fooXyzzy, int barBaz) {
 *         return new SubcomponentBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Subcomponent, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Subcomponent
 *
 */
@Generated("mdsal-binding-generator")
public class SubcomponentBuilder {

    private Config _config;
    private Object _name;
    private State _state;
    private SubcomponentKey key;


    Map<Class<? extends Augmentation<Subcomponent>>, Augmentation<Subcomponent>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SubcomponentBuilder() {
        // No-op
    }

    
    

    /**
     * Construct a builder initialized with state from specified {@link Subcomponent}.
     *
     * @param base Subcomponent from which the builder should be initialized
     */
    public SubcomponentBuilder(Subcomponent base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this.key = base.key();
        this._name = base.getName();
        this._config = base.getConfig();
        this._state = base.getState();
    }



    /**
     * Return current value associated with the property corresponding to {@link Subcomponent#key()}.
     *
     * @return current value
     */
    public SubcomponentKey key() {
        return key;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Subcomponent#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Subcomponent#getName()}.
     *
     * @return current value
     */
    public Object getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Subcomponent#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Subcomponent>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    /**
     * Set the key value corresponding to {@link Subcomponent#key()} to the specified
     * value.
     *
     * @param key desired value
     * @return this builder
     */
    public SubcomponentBuilder withKey(final SubcomponentKey key) {
        this.key = key;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Subcomponent#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SubcomponentBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Subcomponent#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SubcomponentBuilder setName(final Object value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Subcomponent#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SubcomponentBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SubcomponentBuilder addAugmentation(Augmentation<Subcomponent> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SubcomponentBuilder removeAugmentation(Class<? extends Augmentation<Subcomponent>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Subcomponent} instance.
     *
     * @return A new {@link Subcomponent} instance.
     */
    public @NonNull Subcomponent build() {
        return new SubcomponentImpl(this);
    }

    private static final class SubcomponentImpl
        extends AbstractAugmentable<Subcomponent>
        implements Subcomponent {
    
        private final Config _config;
        private final Object _name;
        private final State _state;
        private final SubcomponentKey key;
    
        SubcomponentImpl(SubcomponentBuilder base) {
            super(base.augmentation);
            if (base.key() != null) {
                this.key = base.key();
            } else {
                this.key = new SubcomponentKey(base.getName());
            }
            this._name = key.getName();
            this._config = base.getConfig();
            this._state = base.getState();
        }
    
        @Override
        public SubcomponentKey key() {
            return key;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public Object getName() {
            return _name;
        }
        
        @Override
        public State getState() {
            return _state;
        }
    
        @Override
        public Config nonnullConfig() {
            return Objects.requireNonNullElse(getConfig(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents.subcomponent.ConfigBuilder.empty());
        }
        
        
        @Override
        public State nonnullState() {
            return Objects.requireNonNullElse(getState(), org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents.subcomponent.StateBuilder.empty());
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Subcomponent.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Subcomponent.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Subcomponent.bindingToString(this);
        }
    }
}
