package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformSubcomponentRefTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents.Subcomponent;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.subcomponents.SubcomponentKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Enclosing container for subcomponent references
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * container subcomponents {
 *   list subcomponent {
 *     key name;
 *     leaf name {
 *       type leafref {
 *         path ../config/name;
 *       }
 *     }
 *     container config {
 *       uses platform-subcomponent-ref-config;
 *     }
 *     container state {
 *       config false;
 *       uses platform-subcomponent-ref-config;
 *       uses platform-subcomponent-ref-state;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link SubcomponentsBuilder}.
 * @see SubcomponentsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Subcomponents
    extends
    ChildOf<PlatformSubcomponentRefTop>,
    Augmentable<Subcomponents>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("subcomponents");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.Subcomponents> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.Subcomponents.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.@NonNull Subcomponents obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getSubcomponent());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.@NonNull Subcomponents thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.Subcomponents.class, obj);
        return other != null
            && Objects.equals(thisObj.getSubcomponent(), other.getSubcomponent())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.subcomponent.ref.top.@NonNull Subcomponents obj) {
        final var helper = MoreObjects.toStringHelper("Subcomponents");
        CodeHelpers.appendValue(helper, "subcomponent", obj.getSubcomponent());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return subcomponent, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of subcomponent references
     *     </code>
     * </pre>
     *
     * @return {@code Map<SubcomponentKey, Subcomponent>} subcomponent, or {@code null} if it is not present.
     *
     */
    @Nullable Map<SubcomponentKey, Subcomponent> getSubcomponent();
    
    /**
     * Return subcomponent, or an empty list if it is not present.
     *
     * @return {@code Map<SubcomponentKey, Subcomponent>} subcomponent, or an empty list if it is not present.
     *
     */
    default @NonNull Map<SubcomponentKey, Subcomponent> nonnullSubcomponent() {
        return CodeHelpers.nonnull(getSubcomponent());
    }

}

