package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.PlatformComponentMemoryState;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * For components that have associated memory, these values report information 
 * about available and utilized memory.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * container memory {
 *   leaf available {
 *     type uint64;
 *     units bytes;
 *   }
 *   leaf utilized {
 *     type uint64;
 *     units bytes;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link MemoryBuilder}.
 * @see MemoryBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Memory
    extends
    ChildOf<PlatformComponentMemoryState>,
    Augmentable<Memory>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("memory");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state.Memory> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state.Memory.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state.@NonNull Memory obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAvailable());
        result = prime * result + Objects.hashCode(obj.getUtilized());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state.@NonNull Memory thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state.Memory.class, obj);
        return other != null
            && Objects.equals(thisObj.getAvailable(), other.getAvailable())
            && Objects.equals(thisObj.getUtilized(), other.getUtilized())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118.platform.component.memory.state.@NonNull Memory obj) {
        final var helper = MoreObjects.toStringHelper("Memory");
        CodeHelpers.appendValue(helper, "available", obj.getAvailable());
        CodeHelpers.appendValue(helper, "utilized", obj.getUtilized());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return available, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The available memory physically installed, or logically allocated to the
     *         component.
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} available, or {@code null} if it is not present.
     *
     */
    Uint64 getAvailable();
    
    /**
     * Return available, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The available memory physically installed, or logically allocated to the
     *         component.
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} available, guaranteed to be non-null.
     * @throws NoSuchElementException if available is not present
     *
     */
    default @NonNull Uint64 requireAvailable() {
        return CodeHelpers.require(getAvailable(), "available");
    }
    
    /**
     * Return utilized, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The memory currently in use by processes running on the component, not
     *         considering reserved memory that is not available for use.
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} utilized, or {@code null} if it is not present.
     *
     */
    Uint64 getUtilized();
    
    /**
     * Return utilized, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The memory currently in use by processes running on the component, not
     *         considering reserved memory that is not available for use.
     *     </code>
     * </pre>
     *
     * @return {@code Uint64} utilized, guaranteed to be non-null.
     * @throws NoSuchElementException if utilized is not present
     *
     */
    default @NonNull Uint64 requireUtilized() {
        return CodeHelpers.require(getUtilized(), "utilized");
    }

}

