package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.platform.rev210118;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.UnionTypeObject;
import org.opendaylight.yangtools.yang.common.Decimal64;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * System-defined configuration data for component properties
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
 * <pre>
 * grouping platform-component-properties-config {
 *   leaf name {
 *     type string;
 *   }
 *   leaf value {
 *     type union {
 *       type string;
 *       type boolean;
 *       type int64;
 *       type uint64;
 *       type decimal64 {
 *         fraction-digits 2;
 *       }
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface PlatformComponentPropertiesConfig
    extends
    DataObject
{

    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-platform</b>
     * <pre>
     * leaf value {
     *   type union {
     *     type string;
     *     type boolean;
     *     type int64;
     *     type uint64;
     *     type decimal64 {
     *       fraction-digits 2;
     *     }
     *   }
     * }
     * </pre>
     *
     */
    public static final class Value
     implements UnionTypeObject, Serializable {
        @java.io.Serial
        private static final long serialVersionUID = 3612491071025770245L;
        private final String _string;
        private final Boolean _boolean;
        private final Long _int64;
        private final Uint64 _uint64;
        private final Decimal64 _decimal64;
    
    
        public Value(String _string) {
            this._string = Objects.requireNonNull(_string);
            this._boolean = null;
            this._int64 = null;
            this._uint64 = null;
            this._decimal64 = null;
        }
        
        public Value(Boolean _boolean) {
            this._string = null;
            this._boolean = Objects.requireNonNull(_boolean);
            this._int64 = null;
            this._uint64 = null;
            this._decimal64 = null;
        }
        
        public Value(Long _int64) {
            this._string = null;
            this._boolean = null;
            this._int64 = Objects.requireNonNull(_int64);
            this._uint64 = null;
            this._decimal64 = null;
        }
        
        public Value(Uint64 _uint64) {
            this._string = null;
            this._boolean = null;
            this._int64 = null;
            this._uint64 = Objects.requireNonNull(_uint64);
            this._decimal64 = null;
        }
        
        public Value(Decimal64 _decimal64) {
            this._string = null;
            this._boolean = null;
            this._int64 = null;
            this._uint64 = null;
            this._decimal64 = Objects.requireNonNull(_decimal64);
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public Value(Value source) {
            this._string = source._string;
            this._boolean = source._boolean;
            this._int64 = source._int64;
            this._uint64 = source._uint64;
            this._decimal64 = source._decimal64;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_string != null) {
                return _string;
            }
            if (_boolean != null) {
                return _boolean.toString();
            }
            if (_int64 != null) {
                return _int64.toString();
            }
            if (_uint64 != null) {
                return _uint64.toCanonicalString();
            }
            if (_decimal64 != null) {
                return _decimal64.toCanonicalString();
            }
            throw new IllegalStateException("No value assigned");
        }
    
    
        public String getString() {
            return _string;
        }
        
        public Boolean getBoolean() {
            return _boolean;
        }
        
        public Long getInt64() {
            return _int64;
        }
        
        public Uint64 getUint64() {
            return _uint64;
        }
        
        public Decimal64 getDecimal64() {
            return _decimal64;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_string);
            result = prime * result + Objects.hashCode(_boolean);
            result = prime * result + Objects.hashCode(_int64);
            result = prime * result + Objects.hashCode(_uint64);
            result = prime * result + Objects.hashCode(_decimal64);
            return result;
        }
    
        @Override
        public final boolean equals(Object obj) {
            return this == obj || obj instanceof Value other
                && Objects.equals(_string, other._string)        
                && Objects.equals(_boolean, other._boolean)        
                && Objects.equals(_int64, other._int64)        
                && Objects.equals(_uint64, other._uint64)        
                && Objects.equals(_decimal64, other._decimal64);
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(Value.class);
            CodeHelpers.appendValue(helper, "string", _string);
            CodeHelpers.appendValue(helper, "boolean", _boolean);
            CodeHelpers.appendValue(helper, "int64", _int64);
            CodeHelpers.appendValue(helper, "uint64", _uint64);
            CodeHelpers.appendValue(helper, "decimal64", _decimal64);
            return helper.toString();
        }
    }
    


    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("platform-component-properties-config");

    @Override
    Class<? extends PlatformComponentPropertiesConfig> implementedInterface();
    
    /**
     * Return name, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         System-supplied name of the property -- this is typically non-configurable
     *     </code>
     * </pre>
     *
     * @return {@code String} name, or {@code null} if it is not present.
     *
     */
    String getName();
    
    /**
     * Return name, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         System-supplied name of the property -- this is typically non-configurable
     *     </code>
     * </pre>
     *
     * @return {@code String} name, guaranteed to be non-null.
     * @throws NoSuchElementException if name is not present
     *
     */
    default @NonNull String requireName() {
        return CodeHelpers.require(getName(), "name");
    }
    
    /**
     * Return value, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Property values can take on a variety of types. Signed and unsigned integer
     *         types may be provided in smaller sizes, e.g., int8, uint16, etc.
     *     </code>
     * </pre>
     *
     * @return {@code Value} value, or {@code null} if it is not present.
     *
     */
    Value getValue();
    
    /**
     * Return value, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Property values can take on a variety of types. Signed and unsigned integer
     *         types may be provided in smaller sizes, e.g., int8, uint16, etc.
     *     </code>
     * </pre>
     *
     * @return {@code Value} value, guaranteed to be non-null.
     * @throws NoSuchElementException if value is not present
     *
     */
    default @NonNull Value requireValue() {
        return CodeHelpers.require(getValue(), "value");
    }

}

