package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.openflow.rev181121.openflow.agent.top.Agent;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level for the Openflow agent model
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-openflow</b>
 * <pre>
 * grouping openflow-agent-top {
 *   container agent {
 *     container config {
 *       uses openflow-agent-config;
 *     }
 *     container state {
 *       config false;
 *       uses openflow-agent-config;
 *       uses openflow-agent-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenflowAgentTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("openflow-agent-top");

    @Override
    Class<? extends OpenflowAgentTop> implementedInterface();
    
    /**
     * Return agent, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Container for the Openflow agent model.
     *     </code>
     * </pre>
     *
     * @return {@code Agent} agent, or {@code null} if it is not present.
     *
     */
    Agent getAgent();
    
    /**
     * Return agent, or an empty instance if it is not present.
     *
     * @return {@code Agent} agent, or an empty instance if it is not present.
     *
     */
    @NonNull Agent nonnullAgent();

}

