package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.MessagesState;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 * Syslog messages the client is Subscribing to. This is all messages currently 
 * configured to be sent according to syslog-severity.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-messages</b>
 * <pre>
 * container message {
 *   oc-ext:telemetry-atomic;
 *   config false;
 *   leaf msg {
 *     type string;
 *   }
 *   leaf priority {
 *     type uint8;
 *   }
 *   leaf app-name {
 *     type string;
 *   }
 *   leaf procid {
 *     type string;
 *   }
 *   leaf msgid {
 *     type string;
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link MessageBuilder}.
 * @see MessageBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Message
    extends
    ChildOf<MessagesState>,
    Augmentable<Message>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("message");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state.Message> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state.Message.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state.@NonNull Message obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAppName());
        result = prime * result + Objects.hashCode(obj.getMsg());
        result = prime * result + Objects.hashCode(obj.getMsgid());
        result = prime * result + Objects.hashCode(obj.getPriority());
        result = prime * result + Objects.hashCode(obj.getProcid());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state.@NonNull Message thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state.Message.class, obj);
        return other != null
            && Objects.equals(thisObj.getPriority(), other.getPriority())
            && Objects.equals(thisObj.getAppName(), other.getAppName())
            && Objects.equals(thisObj.getMsg(), other.getMsg())
            && Objects.equals(thisObj.getMsgid(), other.getMsgid())
            && Objects.equals(thisObj.getProcid(), other.getProcid())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state.@NonNull Message obj) {
        final var helper = MoreObjects.toStringHelper("Message");
        CodeHelpers.appendValue(helper, "appName", obj.getAppName());
        CodeHelpers.appendValue(helper, "msg", obj.getMsg());
        CodeHelpers.appendValue(helper, "msgid", obj.getMsgid());
        CodeHelpers.appendValue(helper, "priority", obj.getPriority());
        CodeHelpers.appendValue(helper, "procid", obj.getProcid());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return msg, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Message payload. If other leafs within this container not supported, this leaf
     *         MAY include the entire message, inclding pri, procid, app-name etc..
     *     </code>
     * </pre>
     *
     * @return {@code String} msg, or {@code null} if it is not present.
     *
     */
    String getMsg();
    
    /**
     * Return msg, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Message payload. If other leafs within this container not supported, this leaf
     *         MAY include the entire message, inclding pri, procid, app-name etc..
     *     </code>
     * </pre>
     *
     * @return {@code String} msg, guaranteed to be non-null.
     * @throws NoSuchElementException if msg is not present
     *
     */
    default @NonNull String requireMsg() {
        return CodeHelpers.require(getMsg(), "msg");
    }
    
    /**
     * Return priority, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The Priority value (PRIVAL) represents both the Facility and Severity.
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} priority, or {@code null} if it is not present.
     *
     */
    Uint8 getPriority();
    
    /**
     * Return priority, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The Priority value (PRIVAL) represents both the Facility and Severity.
     *     </code>
     * </pre>
     *
     * @return {@code Uint8} priority, guaranteed to be non-null.
     * @throws NoSuchElementException if priority is not present
     *
     */
    default @NonNull Uint8 requirePriority() {
        return CodeHelpers.require(getPriority(), "priority");
    }
    
    /**
     * Return appName, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The APP-NAME field SHOULD identify the device or application that originated the
     *         message.
     *     </code>
     * </pre>
     *
     * @return {@code String} appName, or {@code null} if it is not present.
     *
     */
    String getAppName();
    
    /**
     * Return appName, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The APP-NAME field SHOULD identify the device or application that originated the
     *         message.
     *     </code>
     * </pre>
     *
     * @return {@code String} appName, guaranteed to be non-null.
     * @throws NoSuchElementException if appName is not present
     *
     */
    default @NonNull String requireAppName() {
        return CodeHelpers.require(getAppName(), "appname");
    }
    
    /**
     * Return procid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         PROCID is a value that is included in the message, having no interoperable
     *         meaning, except that a change in the value indicates there has been a
     *         discontinuity in syslog reporting.
     *     </code>
     * </pre>
     *
     * @return {@code String} procid, or {@code null} if it is not present.
     *
     */
    String getProcid();
    
    /**
     * Return procid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         PROCID is a value that is included in the message, having no interoperable
     *         meaning, except that a change in the value indicates there has been a
     *         discontinuity in syslog reporting.
     *     </code>
     * </pre>
     *
     * @return {@code String} procid, guaranteed to be non-null.
     * @throws NoSuchElementException if procid is not present
     *
     */
    default @NonNull String requireProcid() {
        return CodeHelpers.require(getProcid(), "procid");
    }
    
    /**
     * Return msgid, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         The MSGID SHOULD identify the type of message. For example, a firewall might use
     *         the MSGID 'TCPIN' for incoming TCP traffic and the MSGID 'TCPOUT' for outgoing
     *         TCP traffic.
     *     </code>
     * </pre>
     *
     * @return {@code String} msgid, or {@code null} if it is not present.
     *
     */
    String getMsgid();
    
    /**
     * Return msgid, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         The MSGID SHOULD identify the type of message. For example, a firewall might use
     *         the MSGID 'TCPIN' for incoming TCP traffic and the MSGID 'TCPOUT' for outgoing
     *         TCP traffic.
     *     </code>
     * </pre>
     *
     * @return {@code String} msgid, guaranteed to be non-null.
     * @throws NoSuchElementException if msgid is not present
     *
     */
    default @NonNull String requireMsgid() {
        return CodeHelpers.require(getMsgid(), "msgid");
    }

}

