package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.top.Messages;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for Syslog messages.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-messages</b>
 * <pre>
 * grouping messages-top {
 *   container messages {
 *     container config {
 *       uses messages-config;
 *     }
 *     container state {
 *       config false;
 *       uses messages-config;
 *       uses messages-state;
 *     }
 *     uses debug-messages-top;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface MessagesTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("messages-top");

    @Override
    Class<? extends MessagesTop> implementedInterface();
    
    /**
     * Return messages, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for Syslog messages.
     *     </code>
     * </pre>
     *
     * @return {@code Messages} messages, or {@code null} if it is not present.
     *
     */
    Messages getMessages();
    
    /**
     * Return messages, or an empty instance if it is not present.
     *
     * @return {@code Messages} messages, or an empty instance if it is not present.
     *
     */
    @NonNull Messages nonnullMessages();

}

