package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseConfig.LicenseData;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseState;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint64;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private Boolean _active;
    private String _description;
    private Uint64 _expirationDate;
    private Boolean _expired;
    private Boolean _inUse;
    private Uint64 _issueDate;
    private LicenseData _licenseData;
    private String _licenseId;
    private Boolean _valid;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link LicenseConfig}.
     *
     * @param arg LicenseConfig from which the builder should be initialized
     */
    public StateBuilder(LicenseConfig arg) {
        this._licenseId = arg.getLicenseId();
        this._licenseData = arg.getLicenseData();
        this._active = arg.getActive();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link LicenseState}.
     *
     * @param arg LicenseState from which the builder should be initialized
     */
    public StateBuilder(LicenseState arg) {
        this._description = arg.getDescription();
        this._issueDate = arg.getIssueDate();
        this._expirationDate = arg.getExpirationDate();
        this._inUse = arg.getInUse();
        this._expired = arg.getExpired();
        this._valid = arg.getValid();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._active = base.getActive();
        this._description = base.getDescription();
        this._expirationDate = base.getExpirationDate();
        this._expired = base.getExpired();
        this._inUse = base.getInUse();
        this._issueDate = base.getIssueDate();
        this._licenseData = base.getLicenseData();
        this._licenseId = base.getLicenseId();
        this._valid = base.getValid();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link LicenseConfig}</li>
     *   <li>{@link LicenseState}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LicenseConfig castArg) {
            this._licenseId = castArg.getLicenseId();
            this._licenseData = castArg.getLicenseData();
            this._active = castArg.getActive();
            isValidArg = true;
        }
        if (arg instanceof LicenseState castArg) {
            this._description = castArg.getDescription();
            this._issueDate = castArg.getIssueDate();
            this._expirationDate = castArg.getExpirationDate();
            this._inUse = castArg.getInUse();
            this._expired = castArg.getExpired();
            this._valid = castArg.getValid();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[LicenseConfig, LicenseState]");
    }

    private static final class LazyEmpty {
        static final @NonNull State INSTANCE = new StateBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of State.
     *
     * @return An empty {@link State}
     */
    public static @NonNull State empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getActive()}.
     *
     * @return current value
     */
    public Boolean getActive() {
        return _active;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getDescription()}.
     *
     * @return current value
     */
    public String getDescription() {
        return _description;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getExpirationDate()}.
     *
     * @return current value
     */
    public Uint64 getExpirationDate() {
        return _expirationDate;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getExpired()}.
     *
     * @return current value
     */
    public Boolean getExpired() {
        return _expired;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getInUse()}.
     *
     * @return current value
     */
    public Boolean getInUse() {
        return _inUse;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getIssueDate()}.
     *
     * @return current value
     */
    public Uint64 getIssueDate() {
        return _issueDate;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getLicenseData()}.
     *
     * @return current value
     */
    public LicenseData getLicenseData() {
        return _licenseData;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getLicenseId()}.
     *
     * @return current value
     */
    public String getLicenseId() {
        return _licenseId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getValid()}.
     *
     * @return current value
     */
    public Boolean getValid() {
        return _valid;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getActive()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setActive(final Boolean value) {
        this._active = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getDescription()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setDescription(final String value) {
        this._description = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getExpirationDate()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setExpirationDate(final Uint64 value) {
        this._expirationDate = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getExpired()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setExpired(final Boolean value) {
        this._expired = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getInUse()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setInUse(final Boolean value) {
        this._inUse = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getIssueDate()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setIssueDate(final Uint64 value) {
        this._issueDate = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getLicenseData()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setLicenseData(final LicenseData value) {
        this._licenseData = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getLicenseId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setLicenseId(final String value) {
        this._licenseId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getValid()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setValid(final Boolean value) {
        this._valid = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final Boolean _active;
        private final String _description;
        private final Uint64 _expirationDate;
        private final Boolean _expired;
        private final Boolean _inUse;
        private final Uint64 _issueDate;
        private final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseConfig.LicenseData _licenseData;
        private final String _licenseId;
        private final Boolean _valid;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._active = base.getActive();
            this._description = base.getDescription();
            this._expirationDate = base.getExpirationDate();
            this._expired = base.getExpired();
            this._inUse = base.getInUse();
            this._issueDate = base.getIssueDate();
            this._licenseData = base.getLicenseData();
            this._licenseId = base.getLicenseId();
            this._valid = base.getValid();
        }
    
        @Override
        public Boolean getActive() {
            return _active;
        }
        
        @Override
        public String getDescription() {
            return _description;
        }
        
        @Override
        public Uint64 getExpirationDate() {
            return _expirationDate;
        }
        
        @Override
        public Boolean getExpired() {
            return _expired;
        }
        
        @Override
        public Boolean getInUse() {
            return _inUse;
        }
        
        @Override
        public Uint64 getIssueDate() {
            return _issueDate;
        }
        
        @Override
        public org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseConfig.LicenseData getLicenseData() {
            return _licenseData;
        }
        
        @Override
        public String getLicenseId() {
            return _licenseId;
        }
        
        @Override
        public Boolean getValid() {
            return _valid;
        }
    
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
