package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.ethernet.rev210609.ethernet._interface.state.Counters;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.MacAddress;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.EnumTypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Grouping for defining Ethernet-specific operational state
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-if-ethernet</b>
 * <pre>
 * grouping ethernet-interface-state {
 *   leaf hw-mac-address {
 *     type oc-yang:mac-address;
 *   }
 *   leaf negotiated-duplex-mode {
 *     type enumeration {
 *       enum FULL {
 *       }
 *       enum HALF {
 *       }
 *     }
 *   }
 *   leaf negotiated-port-speed {
 *     type identityref {
 *       base ETHERNET_SPEED;
 *     }
 *   }
 *   container counters {
 *     uses ethernet-interface-state-counters;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface EthernetInterfaceState
    extends
    DataObject
{


    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-if-ethernet</b>
     * <pre>
     * leaf negotiated-duplex-mode {
     *   type enumeration {
     *     enum FULL {
     *     }
     *     enum HALF {
     *     }
     *   }
     * }
     * </pre>
     *
     */
    @Generated("mdsal-binding-generator")
    public enum NegotiatedDuplexMode implements EnumTypeObject {
        /**
         * Full duplex mode
         */
        FULL(0, "FULL"),
        
        /**
         * Half duplex mode
         */
        HALF(1, "HALF")
        ;
    
        private final @NonNull String name;
        private final int value;
    
        private NegotiatedDuplexMode(int value, @NonNull String name) {
            this.value = value;
            this.name = name;
        }
    
        @Override
        public @NonNull String getName() {
            return name;
        }
    
        @Override
        public int getIntValue() {
            return value;
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding NegotiatedDuplexMode item, or {@code null} if no such item exists
         * @throws NullPointerException if {@code name} is null
         */
        public static @Nullable NegotiatedDuplexMode forName(String name) {
            return switch (name) {
                case "FULL" -> FULL;
                case "HALF" -> HALF;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding NegotiatedDuplexMode item, or {@code null} if no such item exists
         */
        public static @Nullable NegotiatedDuplexMode forValue(int intValue) {
            return switch (intValue) {
                case 0 -> FULL;
                case 1 -> HALF;
                default -> null;
            };
        }
    
        /**
         * Return the enumeration member whose {@link #getName()} matches specified assigned name.
         *
         * @param name YANG assigned name
         * @return corresponding NegotiatedDuplexMode item
         * @throws NullPointerException if {@code name} is null
         * @throws IllegalArgumentException if {@code name} does not match any item
         */
        public static @NonNull NegotiatedDuplexMode ofName(String name) {
            return CodeHelpers.checkEnum(forName(name), name);
        }
    
        /**
         * Return the enumeration member whose {@link #getIntValue()} matches specified value.
         *
         * @param intValue integer value
         * @return corresponding NegotiatedDuplexMode item
         * @throws IllegalArgumentException if {@code intValue} does not match any item
         */
        public static @NonNull NegotiatedDuplexMode ofValue(int intValue) {
            return CodeHelpers.checkEnum(forValue(intValue), intValue);
        }
    }

    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("ethernet-interface-state");

    @Override
    Class<? extends EthernetInterfaceState> implementedInterface();
    
    /**
     * Return hwMacAddress, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Represenets the 'burned-in', or system-assigned, MAC address for the Ethernet
     *         interface.
     *     </code>
     * </pre>
     *
     * @return {@code MacAddress} hwMacAddress, or {@code null} if it is not present.
     *
     */
    MacAddress getHwMacAddress();
    
    /**
     * Return hwMacAddress, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Represenets the 'burned-in', or system-assigned, MAC address for the Ethernet
     *         interface.
     *     </code>
     * </pre>
     *
     * @return {@code MacAddress} hwMacAddress, guaranteed to be non-null.
     * @throws NoSuchElementException if hwMacAddress is not present
     *
     */
    default @NonNull MacAddress requireHwMacAddress() {
        return CodeHelpers.require(getHwMacAddress(), "hwmacaddress");
    }
    
    /**
     * Return negotiatedDuplexMode, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is set to TRUE, and the interface has completed
     *         auto-negotiation with the remote peer, this value shows the duplex mode that has
     *         been negotiated.
     *     </code>
     * </pre>
     *
     * @return {@code NegotiatedDuplexMode} negotiatedDuplexMode, or {@code null} if it is not present.
     *
     */
    NegotiatedDuplexMode getNegotiatedDuplexMode();
    
    /**
     * Return negotiatedDuplexMode, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is set to TRUE, and the interface has completed
     *         auto-negotiation with the remote peer, this value shows the duplex mode that has
     *         been negotiated.
     *     </code>
     * </pre>
     *
     * @return {@code NegotiatedDuplexMode} negotiatedDuplexMode, guaranteed to be non-null.
     * @throws NoSuchElementException if negotiatedDuplexMode is not present
     *
     */
    default @NonNull NegotiatedDuplexMode requireNegotiatedDuplexMode() {
        return CodeHelpers.require(getNegotiatedDuplexMode(), "negotiatedduplexmode");
    }
    
    /**
     * Return negotiatedPortSpeed, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is set to TRUE, and the interface has completed
     *         auto-negotiation with the remote peer, this value shows the interface speed that
     *         has been negotiated.
     *     </code>
     * </pre>
     *
     * @return {@code ETHERNETSPEED} negotiatedPortSpeed, or {@code null} if it is not present.
     *
     */
    ETHERNETSPEED getNegotiatedPortSpeed();
    
    /**
     * Return negotiatedPortSpeed, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         When auto-negotiate is set to TRUE, and the interface has completed
     *         auto-negotiation with the remote peer, this value shows the interface speed that
     *         has been negotiated.
     *     </code>
     * </pre>
     *
     * @return {@code ETHERNETSPEED} negotiatedPortSpeed, guaranteed to be non-null.
     * @throws NoSuchElementException if negotiatedPortSpeed is not present
     *
     */
    default @NonNull ETHERNETSPEED requireNegotiatedPortSpeed() {
        return CodeHelpers.require(getNegotiatedPortSpeed(), "negotiatedportspeed");
    }
    
    /**
     * Return counters, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Ethernet interface counters
     *     </code>
     * </pre>
     *
     * @return {@code Counters} counters, or {@code null} if it is not present.
     *
     */
    Counters getCounters();
    
    /**
     * Return counters, or an empty instance if it is not present.
     *
     * @return {@code Counters} counters, or an empty instance if it is not present.
     *
     */
    @NonNull Counters nonnullCounters();

}

