package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.interfaces.aggregate.rev200501;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link Config1} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Config1 createConfig1(int fooXyzzy, int barBaz) {
 *         return new Config1Builder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Config1, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Config1
 *
 */
@Generated("mdsal-binding-generator")
public class Config1Builder {

    private String _aggregateId;



    /**
     * Construct an empty builder.
     */
    public Config1Builder() {
        // No-op
    }

    
    /**
     * Construct a new builder initialized from specified {@link EthernetIfAggregationConfig}.
     *
     * @param arg EthernetIfAggregationConfig from which the builder should be initialized
     */
    public Config1Builder(EthernetIfAggregationConfig arg) {
        this._aggregateId = arg.getAggregateId();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Config1}.
     *
     * @param base Config1 from which the builder should be initialized
     */
    public Config1Builder(Config1 base) {
        this._aggregateId = base.getAggregateId();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link EthernetIfAggregationConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof EthernetIfAggregationConfig castArg) {
            this._aggregateId = castArg.getAggregateId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[EthernetIfAggregationConfig]");
    }


    /**
     * Return current value associated with the property corresponding to {@link Config1#getAggregateId()}.
     *
     * @return current value
     */
    public String getAggregateId() {
        return _aggregateId;
    }

    
    /**
     * Set the property corresponding to {@link Config1#getAggregateId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public Config1Builder setAggregateId(final String value) {
        this._aggregateId = value;
        return this;
    }
    

    /**
     * A new {@link Config1} instance.
     *
     * @return A new {@link Config1} instance.
     */
    public @NonNull Config1 build() {
        return new Config1Impl(this);
    }

    private static final class Config1Impl
        implements Config1 {
    
        private final String _aggregateId;
    
        Config1Impl(Config1Builder base) {
            this._aggregateId = base.getAggregateId();
        }
    
        @Override
        public String getAggregateId() {
            return _aggregateId;
        }
    
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Config1.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Config1.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Config1.bindingToString(this);
        }
    }
}
