package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.types.rev181121;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module defines operational state data related to alarms that the device is 
 * reporting. This model reuses some data items defined in the draft IETF YANG 
 * Alarm Module: https://tools.ietf.org/html/draft-vallin-netmod-alarm-module-02 
 * Portions of this code were derived from the draft IETF YANG Alarm Module. 
 * reproduce this note if possible. IETF code is subject to the following 
 * and license: Copyright (c) IETF Trust and the persons identified as authors of 
 * the code. All rights reserved. Redistribution and use in source and binary 
 * forms, with or without modification, is permitted pursuant to, and subject to 
 * the license terms contained in, the Simplified BSD License set forth in Section 
 * 4.c of the IETF Trust's Legal Provisions Relating to IETF Documents 
 * (http://trustee.ietf.org/license-info).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-alarm-types</b>
 * <pre>
 * module openconfig-alarm-types {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/alarms/types";
 *   prefix oc-alarm-types;
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   oc-ext:openconfig-version 0.2.1;
 *   revision 2018-11-21 {
 *   }
 *   revision 2018-01-16 {
 *   }
 *   oc-ext:regexp-posix;
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   identity OPENCONFIG_ALARM_TYPE_ID {
 *   }
 *   identity AIS {
 *     base OPENCONFIG_ALARM_TYPE_ID;
 *   }
 *   identity EQPT {
 *     base OPENCONFIG_ALARM_TYPE_ID;
 *   }
 *   identity LOS {
 *     base OPENCONFIG_ALARM_TYPE_ID;
 *   }
 *   identity OTS {
 *     base OPENCONFIG_ALARM_TYPE_ID;
 *   }
 *   identity OPENCONFIG_ALARM_SEVERITY {
 *   }
 *   identity UNKNOWN {
 *     base OPENCONFIG_ALARM_SEVERITY;
 *   }
 *   identity MINOR {
 *     base OPENCONFIG_ALARM_SEVERITY;
 *   }
 *   identity WARNING {
 *     base OPENCONFIG_ALARM_SEVERITY;
 *   }
 *   identity MAJOR {
 *     base OPENCONFIG_ALARM_SEVERITY;
 *   }
 *   identity CRITICAL {
 *     base OPENCONFIG_ALARM_SEVERITY;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigAlarmTypesData
    extends
    DataRoot
{





}

