package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.Alarm;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.alarms.AlarmKey;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level container for device alarms
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-alarms</b>
 * <pre>
 * container alarms {
 *   config false;
 *   list alarm {
 *     key id;
 *     leaf id {
 *       type leafref {
 *         path ../state/id;
 *       }
 *     }
 *     container config {
 *       uses alarm-config;
 *     }
 *     container state {
 *       config false;
 *       uses alarm-config;
 *       uses alarm-state;
 *     }
 *   }
 * }
 * </pre>
 * <p>To create instances of this class use {@link AlarmsBuilder}.
 * @see AlarmsBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface Alarms
    extends
    ChildOf<AlarmsTop>,
    Augmentable<Alarms>
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("alarms");

    @Override
    default Class<org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.Alarms> implementedInterface() {
        return org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.Alarms.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.@NonNull Alarms obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAlarm());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is {@code null}
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.@NonNull Alarms thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final var other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.Alarms.class, obj);
        return other != null
            && Objects.equals(thisObj.getAlarm(), other.getAlarm())
            && thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is {@code null}
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.@NonNull Alarms obj) {
        final var helper = MoreObjects.toStringHelper("Alarms");
        CodeHelpers.appendValue(helper, "alarm", obj.getAlarm());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return alarm, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         List of alarms, keyed by a unique id
     *     </code>
     * </pre>
     *
     * @return {@code Map<AlarmKey, Alarm>} alarm, or {@code null} if it is not present.
     *
     */
    @Nullable Map<AlarmKey, Alarm> getAlarm();
    
    /**
     * Return alarm, or an empty list if it is not present.
     *
     * @return {@code Map<AlarmKey, Alarm>} alarm, or an empty list if it is not present.
     *
     */
    default @NonNull Map<AlarmKey, Alarm> nonnullAlarm() {
        return CodeHelpers.nonnull(getAlarm());
    }

}

