package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.server.top.servers.server;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaServerState;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.IpAddress;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.yang.rev210302.Counter64;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link State} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     State createState(int fooXyzzy, int barBaz) {
 *         return new StateBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of State, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see State
 *
 */
@Generated("mdsal-binding-generator")
public class StateBuilder {

    private IpAddress _address;
    private Counter64 _connectionAborts;
    private Counter64 _connectionCloses;
    private Counter64 _connectionFailures;
    private Counter64 _connectionOpens;
    private Counter64 _connectionTimeouts;
    private Counter64 _errorsReceived;
    private Counter64 _messagesReceived;
    private Counter64 _messagesSent;
    private String _name;
    private Uint16 _timeout;


    Map<Class<? extends Augmentation<State>>, Augmentation<State>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public StateBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link AaaServerConfig}.
     *
     * @param arg AaaServerConfig from which the builder should be initialized
     */
    public StateBuilder(AaaServerConfig arg) {
        this._name = arg.getName();
        this._address = arg.getAddress();
        this._timeout = arg.getTimeout();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link AaaServerState}.
     *
     * @param arg AaaServerState from which the builder should be initialized
     */
    public StateBuilder(AaaServerState arg) {
        this._connectionOpens = arg.getConnectionOpens();
        this._connectionCloses = arg.getConnectionCloses();
        this._connectionAborts = arg.getConnectionAborts();
        this._connectionFailures = arg.getConnectionFailures();
        this._connectionTimeouts = arg.getConnectionTimeouts();
        this._messagesSent = arg.getMessagesSent();
        this._messagesReceived = arg.getMessagesReceived();
        this._errorsReceived = arg.getErrorsReceived();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link State}.
     *
     * @param base State from which the builder should be initialized
     */
    public StateBuilder(State base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._address = base.getAddress();
        this._connectionAborts = base.getConnectionAborts();
        this._connectionCloses = base.getConnectionCloses();
        this._connectionFailures = base.getConnectionFailures();
        this._connectionOpens = base.getConnectionOpens();
        this._connectionTimeouts = base.getConnectionTimeouts();
        this._errorsReceived = base.getErrorsReceived();
        this._messagesReceived = base.getMessagesReceived();
        this._messagesSent = base.getMessagesSent();
        this._name = base.getName();
        this._timeout = base.getTimeout();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link AaaServerState}</li>
     *   <li>{@link AaaServerConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof AaaServerState castArg) {
            this._connectionOpens = castArg.getConnectionOpens();
            this._connectionCloses = castArg.getConnectionCloses();
            this._connectionAborts = castArg.getConnectionAborts();
            this._connectionFailures = castArg.getConnectionFailures();
            this._connectionTimeouts = castArg.getConnectionTimeouts();
            this._messagesSent = castArg.getMessagesSent();
            this._messagesReceived = castArg.getMessagesReceived();
            this._errorsReceived = castArg.getErrorsReceived();
            isValidArg = true;
        }
        if (arg instanceof AaaServerConfig castArg) {
            this._name = castArg.getName();
            this._address = castArg.getAddress();
            this._timeout = castArg.getTimeout();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[AaaServerState, AaaServerConfig]");
    }

    private static final class LazyEmpty {
        static final @NonNull State INSTANCE = new StateBuilder().build();
    
        private LazyEmpty() {
            // Hidden on purpose
        }
    }
    
    /**
     * Get empty instance of State.
     *
     * @return An empty {@link State}
     */
    public static @NonNull State empty() {
        return LazyEmpty.INSTANCE;
    }

    /**
     * Return current value associated with the property corresponding to {@link State#getAddress()}.
     *
     * @return current value
     */
    public IpAddress getAddress() {
        return _address;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getConnectionAborts()}.
     *
     * @return current value
     */
    public Counter64 getConnectionAborts() {
        return _connectionAborts;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getConnectionCloses()}.
     *
     * @return current value
     */
    public Counter64 getConnectionCloses() {
        return _connectionCloses;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getConnectionFailures()}.
     *
     * @return current value
     */
    public Counter64 getConnectionFailures() {
        return _connectionFailures;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getConnectionOpens()}.
     *
     * @return current value
     */
    public Counter64 getConnectionOpens() {
        return _connectionOpens;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getConnectionTimeouts()}.
     *
     * @return current value
     */
    public Counter64 getConnectionTimeouts() {
        return _connectionTimeouts;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getErrorsReceived()}.
     *
     * @return current value
     */
    public Counter64 getErrorsReceived() {
        return _errorsReceived;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMessagesReceived()}.
     *
     * @return current value
     */
    public Counter64 getMessagesReceived() {
        return _messagesReceived;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getMessagesSent()}.
     *
     * @return current value
     */
    public Counter64 getMessagesSent() {
        return _messagesSent;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getName()}.
     *
     * @return current value
     */
    public String getName() {
        return _name;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link State#getTimeout()}.
     *
     * @return current value
     */
    public Uint16 getTimeout() {
        return _timeout;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<State>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link State#getAddress()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setAddress(final IpAddress value) {
        this._address = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getConnectionAborts()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setConnectionAborts(final Counter64 value) {
        this._connectionAborts = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getConnectionCloses()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setConnectionCloses(final Counter64 value) {
        this._connectionCloses = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getConnectionFailures()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setConnectionFailures(final Counter64 value) {
        this._connectionFailures = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getConnectionOpens()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setConnectionOpens(final Counter64 value) {
        this._connectionOpens = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getConnectionTimeouts()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setConnectionTimeouts(final Counter64 value) {
        this._connectionTimeouts = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getErrorsReceived()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setErrorsReceived(final Counter64 value) {
        this._errorsReceived = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getMessagesReceived()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setMessagesReceived(final Counter64 value) {
        this._messagesReceived = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getMessagesSent()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setMessagesSent(final Counter64 value) {
        this._messagesSent = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getName()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setName(final String value) {
        this._name = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link State#getTimeout()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public StateBuilder setTimeout(final Uint16 value) {
        this._timeout = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public StateBuilder addAugmentation(Augmentation<State> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public StateBuilder removeAugmentation(Class<? extends Augmentation<State>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link State} instance.
     *
     * @return A new {@link State} instance.
     */
    public @NonNull State build() {
        return new StateImpl(this);
    }

    private static final class StateImpl
        extends AbstractAugmentable<State>
        implements State {
    
        private final IpAddress _address;
        private final Counter64 _connectionAborts;
        private final Counter64 _connectionCloses;
        private final Counter64 _connectionFailures;
        private final Counter64 _connectionOpens;
        private final Counter64 _connectionTimeouts;
        private final Counter64 _errorsReceived;
        private final Counter64 _messagesReceived;
        private final Counter64 _messagesSent;
        private final String _name;
        private final Uint16 _timeout;
    
        StateImpl(StateBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._connectionAborts = base.getConnectionAborts();
            this._connectionCloses = base.getConnectionCloses();
            this._connectionFailures = base.getConnectionFailures();
            this._connectionOpens = base.getConnectionOpens();
            this._connectionTimeouts = base.getConnectionTimeouts();
            this._errorsReceived = base.getErrorsReceived();
            this._messagesReceived = base.getMessagesReceived();
            this._messagesSent = base.getMessagesSent();
            this._name = base.getName();
            this._timeout = base.getTimeout();
        }
    
        @Override
        public IpAddress getAddress() {
            return _address;
        }
        
        @Override
        public Counter64 getConnectionAborts() {
            return _connectionAborts;
        }
        
        @Override
        public Counter64 getConnectionCloses() {
            return _connectionCloses;
        }
        
        @Override
        public Counter64 getConnectionFailures() {
            return _connectionFailures;
        }
        
        @Override
        public Counter64 getConnectionOpens() {
            return _connectionOpens;
        }
        
        @Override
        public Counter64 getConnectionTimeouts() {
            return _connectionTimeouts;
        }
        
        @Override
        public Counter64 getErrorsReceived() {
            return _errorsReceived;
        }
        
        @Override
        public Counter64 getMessagesReceived() {
            return _messagesReceived;
        }
        
        @Override
        public Counter64 getMessagesSent() {
            return _messagesSent;
        }
        
        @Override
        public String getName() {
            return _name;
        }
        
        @Override
        public Uint16 getTimeout() {
            return _timeout;
        }
    
        
        
        
        
        
        
        
        
        
        
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = State.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return State.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return State.bindingToString(this);
        }
    }
}
