package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.radius.server.top.Radius;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Top-level grouping for RADIUS server data
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-aaa</b>
 * <pre>
 * grouping aaa-radius-server-top {
 *   container radius {
 *     container config {
 *       uses aaa-radius-server-config;
 *     }
 *     container state {
 *       config false;
 *       uses aaa-radius-server-config;
 *       uses aaa-radius-server-state;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface AaaRadiusServerTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("aaa-radius-server-top");

    @Override
    Class<? extends AaaRadiusServerTop> implementedInterface();
    
    /**
     * Return radius, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Top-level container for RADIUS server data
     *     </code>
     * </pre>
     *
     * @return {@code Radius} radius, or {@code null} if it is not present.
     *
     */
    Radius getRadius();
    
    /**
     * Return radius, or an empty instance if it is not present.
     *
     * @return {@code Radius} radius, or an empty instance if it is not present.
     *
     */
    @NonNull Radius nonnullRadius();

}

