/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.ingress.mapping.top.ingress.mapping;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.VlanLogicalIngressMappingConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.ingress.mapping.top.ingress.mapping.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.TPIDTYPES;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanStackAction;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder {
    private TPIDTYPES _tpid;
    private VlanId _vlanId;
    private VlanStackAction _vlanStackAction;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(VlanLogicalIngressMappingConfig arg) {
        this._vlanStackAction = arg.getVlanStackAction();
        this._vlanId = arg.getVlanId();
        this._tpid = arg.getTpid();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._tpid = base.getTpid();
        this._vlanId = base.getVlanId();
        this._vlanStackAction = base.getVlanStackAction();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof VlanLogicalIngressMappingConfig) {
            VlanLogicalIngressMappingConfig castArg = (VlanLogicalIngressMappingConfig)arg;
            this._vlanStackAction = castArg.getVlanStackAction();
            this._vlanId = castArg.getVlanId();
            this._tpid = castArg.getTpid();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[VlanLogicalIngressMappingConfig]");
    }

    public TPIDTYPES getTpid() {
        return this._tpid;
    }

    public VlanId getVlanId() {
        return this._vlanId;
    }

    public VlanStackAction getVlanStackAction() {
        return this._vlanStackAction;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setTpid(TPIDTYPES value) {
        this._tpid = value;
        return this;
    }

    public ConfigBuilder setVlanId(VlanId value) {
        this._vlanId = value;
        return this;
    }

    public ConfigBuilder setVlanStackAction(VlanStackAction value) {
        this._vlanStackAction = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final TPIDTYPES _tpid;
        private final VlanId _vlanId;
        private final VlanStackAction _vlanStackAction;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._tpid = base.getTpid();
            this._vlanId = base.getVlanId();
            this._vlanStackAction = base.getVlanStackAction();
        }

        @Override
        public TPIDTYPES getTpid() {
            return this._tpid;
        }

        @Override
        public VlanId getVlanId() {
            return this._vlanId;
        }

        @Override
        public VlanStackAction getVlanStackAction() {
            return this._vlanStackAction;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

