/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv4Address;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Ipv6Address;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.TypeObject;

public class IpAddress
implements TypeObject,
Serializable {
    private static final long serialVersionUID = 2631789094917437570L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of((Object)"^(?:(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5]))$", (Object)"^(?:(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)))$");
    private static final Pattern[] patterns = CodeHelpers.compilePatterns(PATTERN_CONSTANTS);
    private static final String[] regexes = new String[]{"(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])", "(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))"};
    private final Ipv4Address _ipv4Address;
    private final Ipv6Address _ipv6Address;

    public IpAddress(Ipv4Address _ipv4Address) {
        this._ipv4Address = Objects.requireNonNull(_ipv4Address);
        this._ipv6Address = null;
    }

    public IpAddress(Ipv6Address _ipv6Address) {
        this._ipv6Address = Objects.requireNonNull(_ipv6Address);
        this._ipv4Address = null;
    }

    public IpAddress(IpAddress source) {
        this._ipv4Address = source._ipv4Address;
        this._ipv6Address = source._ipv6Address;
    }

    public String stringValue() {
        if (this._ipv4Address != null) {
            return this._ipv4Address.getValue().toString();
        }
        if (this._ipv6Address != null) {
            return this._ipv6Address.getValue().toString();
        }
        throw new IllegalStateException("No value assigned");
    }

    public Ipv4Address getIpv4Address() {
        return this._ipv4Address;
    }

    public Ipv6Address getIpv6Address() {
        return this._ipv6Address;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._ipv4Address);
        result = 31 * result + Objects.hashCode(this._ipv6Address);
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IpAddress)) {
            return false;
        }
        IpAddress other = (IpAddress)obj;
        if (!Objects.equals(this._ipv4Address, other._ipv4Address)) {
            return false;
        }
        return Objects.equals(this._ipv6Address, other._ipv6Address);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(IpAddress.class);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"ipv4Address", (Object)this._ipv4Address);
        CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"ipv6Address", (Object)this._ipv6Address);
        return helper.toString();
    }
}

