/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpServerConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.server.top.servers.server.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.Host;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107.PortNumber;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint8;

public class ConfigBuilder {
    private Host _address;
    private SystemNtpServerConfig.AssociationType _associationType;
    private Boolean _iburst;
    private PortNumber _port;
    private Boolean _prefer;
    private Uint8 _version;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(SystemNtpServerConfig arg) {
        this._address = arg.getAddress();
        this._port = arg.getPort();
        this._version = arg.getVersion();
        this._associationType = arg.getAssociationType();
        this._iburst = arg.getIburst();
        this._prefer = arg.getPrefer();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._address = base.getAddress();
        this._associationType = base.getAssociationType();
        this._iburst = base.getIburst();
        this._port = base.getPort();
        this._prefer = base.getPrefer();
        this._version = base.getVersion();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemNtpServerConfig) {
            SystemNtpServerConfig castArg = (SystemNtpServerConfig)arg;
            this._address = castArg.getAddress();
            this._port = castArg.getPort();
            this._version = castArg.getVersion();
            this._associationType = castArg.getAssociationType();
            this._iburst = castArg.getIburst();
            this._prefer = castArg.getPrefer();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[SystemNtpServerConfig]");
    }

    public Host getAddress() {
        return this._address;
    }

    public SystemNtpServerConfig.AssociationType getAssociationType() {
        return this._associationType;
    }

    public Boolean getIburst() {
        return this._iburst;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public Boolean getPrefer() {
        return this._prefer;
    }

    public Uint8 getVersion() {
        return this._version;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setAddress(Host value) {
        this._address = value;
        return this;
    }

    public ConfigBuilder setAssociationType(SystemNtpServerConfig.AssociationType value) {
        this._associationType = value;
        return this;
    }

    public ConfigBuilder setIburst(Boolean value) {
        this._iburst = value;
        return this;
    }

    public ConfigBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public ConfigBuilder setPrefer(Boolean value) {
        this._prefer = value;
        return this;
    }

    private static void checkVersionRange(short value) {
        if (value >= 1 && value <= 4) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[1..4]]", (int)value);
    }

    public ConfigBuilder setVersion(Uint8 value) {
        if (value != null) {
            ConfigBuilder.checkVersionRange(value.shortValue());
        }
        this._version = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final Host _address;
        private final SystemNtpServerConfig.AssociationType _associationType;
        private final Boolean _iburst;
        private final PortNumber _port;
        private final Boolean _prefer;
        private final Uint8 _version;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._address = base.getAddress();
            this._associationType = base.getAssociationType();
            this._iburst = base.getIburst();
            this._port = base.getPort();
            this._prefer = base.getPrefer();
            this._version = base.getVersion();
        }

        @Override
        public Host getAddress() {
            return this._address;
        }

        @Override
        public SystemNtpServerConfig.AssociationType getAssociationType() {
            return this._associationType;
        }

        @Override
        public Boolean getIburst() {
            return this._iburst;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        @Override
        public Boolean getPrefer() {
            return this._prefer;
        }

        @Override
        public Uint8 getVersion() {
            return this._version;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

