/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.state.Message;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint8;

public class MessageBuilder {
    private String _appName;
    private String _msg;
    private String _msgid;
    private Uint8 _priority;
    private String _procid;
    Map<Class<? extends Augmentation<Message>>, Augmentation<Message>> augmentation = Map.of();

    public MessageBuilder() {
    }

    public MessageBuilder(Message base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Message>>, Augmentation<Message>>(aug);
        }
        this._appName = base.getAppName();
        this._msg = base.getMsg();
        this._msgid = base.getMsgid();
        this._priority = base.getPriority();
        this._procid = base.getProcid();
    }

    public String getAppName() {
        return this._appName;
    }

    public String getMsg() {
        return this._msg;
    }

    public String getMsgid() {
        return this._msgid;
    }

    public Uint8 getPriority() {
        return this._priority;
    }

    public String getProcid() {
        return this._procid;
    }

    public <E$$ extends Augmentation<Message>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public MessageBuilder setAppName(String value) {
        this._appName = value;
        return this;
    }

    public MessageBuilder setMsg(String value) {
        this._msg = value;
        return this;
    }

    public MessageBuilder setMsgid(String value) {
        this._msgid = value;
        return this;
    }

    public MessageBuilder setPriority(Uint8 value) {
        this._priority = value;
        return this;
    }

    public MessageBuilder setProcid(String value) {
        this._procid = value;
        return this;
    }

    public MessageBuilder addAugmentation(Augmentation<Message> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Message>>, Augmentation<Message>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public MessageBuilder removeAugmentation(Class<? extends Augmentation<Message>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Message build() {
        return new MessageImpl(this);
    }

    private static final class MessageImpl
    extends AbstractAugmentable<Message>
    implements Message {
        private final String _appName;
        private final String _msg;
        private final String _msgid;
        private final Uint8 _priority;
        private final String _procid;
        private int hash = 0;
        private volatile boolean hashValid = false;

        MessageImpl(MessageBuilder base) {
            super(base.augmentation);
            this._appName = base.getAppName();
            this._msg = base.getMsg();
            this._msgid = base.getMsgid();
            this._priority = base.getPriority();
            this._procid = base.getProcid();
        }

        @Override
        public String getAppName() {
            return this._appName;
        }

        @Override
        public String getMsg() {
            return this._msg;
        }

        @Override
        public String getMsgid() {
            return this._msgid;
        }

        @Override
        public Uint8 getPriority() {
            return this._priority;
        }

        @Override
        public String getProcid() {
            return this._procid;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Message.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Message.bindingEquals(this, obj);
        }

        public String toString() {
            return Message.bindingToString(this);
        }
    }
}

