/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseConfig;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.licenses.top.licenses.license.Config;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ConfigBuilder {
    private Boolean _active;
    private LicenseConfig.LicenseData _licenseData;
    private String _licenseId;
    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    public ConfigBuilder() {
    }

    public ConfigBuilder(LicenseConfig arg) {
        this._licenseId = arg.getLicenseId();
        this._licenseData = arg.getLicenseData();
        this._active = arg.getActive();
    }

    public ConfigBuilder(Config base) {
        Map aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>(aug);
        }
        this._active = base.getActive();
        this._licenseData = base.getLicenseData();
        this._licenseId = base.getLicenseId();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LicenseConfig) {
            LicenseConfig castArg = (LicenseConfig)arg;
            this._licenseId = castArg.getLicenseId();
            this._licenseData = castArg.getLicenseData();
            this._active = castArg.getActive();
            isValidArg = true;
        }
        CodeHelpers.validValue((boolean)isValidArg, (Object)arg, (String)"[LicenseConfig]");
    }

    public Boolean getActive() {
        return this._active;
    }

    public LicenseConfig.LicenseData getLicenseData() {
        return this._licenseData;
    }

    public String getLicenseId() {
        return this._licenseId;
    }

    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$)this.augmentation.get(Objects.requireNonNull(augmentationType));
    }

    public ConfigBuilder setActive(Boolean value) {
        this._active = value;
        return this;
    }

    public ConfigBuilder setLicenseData(LicenseConfig.LicenseData value) {
        this._licenseData = value;
        return this;
    }

    public ConfigBuilder setLicenseId(String value) {
        this._licenseId = value;
        return this;
    }

    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Config>>, Augmentation<Config>>();
        }
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }

    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
    extends AbstractAugmentable<Config>
    implements Config {
        private final Boolean _active;
        private final LicenseConfig.LicenseData _licenseData;
        private final String _licenseId;
        private int hash = 0;
        private volatile boolean hashValid = false;

        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._active = base.getActive();
            this._licenseData = base.getLicenseData();
            this._licenseId = base.getLicenseId();
        }

        @Override
        public Boolean getActive() {
            return this._active;
        }

        @Override
        public LicenseConfig.LicenseData getLicenseData() {
            return this._licenseData;
        }

        @Override
        public String getLicenseId() {
            return this._licenseId;
        }

        public int hashCode() {
            int result;
            if (this.hashValid) {
                return this.hash;
            }
            this.hash = result = Config.bindingHashCode(this);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }

        public String toString() {
            return Config.bindingToString(this);
        }
    }
}

