package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan-types</b>
 * <pre>
 * typedef vlan-id {
 *   type uint16 {
 *     range 1..4094;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class VlanId
 implements ScalarTypeObject<Uint16>, Serializable {
    @java.io.Serial
    private static final long serialVersionUID = -3708880084115267596L;
    private final Uint16 _value;

    private static void check_valueRange(final int value) {
        if (value >= 1 && value <= 4094) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..4094]]", value);
    }

    @ConstructorParameters("value")
    public VlanId(Uint16 _value) {
        if (_value != null) {
            check_valueRange(_value.intValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public VlanId(VlanId source) {
        this._value = source._value;
    }

    public static VlanId getDefaultInstance(final String defaultValue) {
        return new VlanId(Uint16.valueOf(defaultValue));
    }

    @Override
    public Uint16 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VlanId)) {
            return false;
        }
        final VlanId other = (VlanId) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(VlanId.class);
        CodeHelpers.appendValue(helper, "value", _value);
        return helper.toString();
    }
}

