package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.lang.Class;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanId;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanModeType;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.types.rev200630.VlanRange;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.TypeObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * VLAN related configuration that is part of the physical Ethernet interface.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-switched-config {
 *   leaf interface-mode {
 *     type oc-vlan-types:vlan-mode-type;
 *   }
 *   leaf native-vlan {
 *     when "../interface-mode = 'TRUNK'" {
 *     }
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf access-vlan {
 *     when "../interface-mode = 'ACCESS'" {
 *     }
 *     type oc-vlan-types:vlan-id;
 *   }
 *   leaf-list trunk-vlans {
 *     when "../interface-mode = 'TRUNK'" {
 *     }
 *     type union {
 *       type oc-vlan-types:vlan-id;
 *       type oc-vlan-types:vlan-range;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanSwitchedConfig
    extends
    DataObject
{

    /**
     *
     * <p>
     * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
     * <pre>
     * leaf-list trunk-vlans {
     *   when "../interface-mode = 'TRUNK'" {
     *   }
     *   type union {
     *     type oc-vlan-types:vlan-id;
     *     type oc-vlan-types:vlan-range;
     *   }
     * }
     * </pre>
     *
     */
    public static final class TrunkVlans
     implements TypeObject, Serializable {
        @java.io.Serial
        private static final long serialVersionUID = 4696041022428618626L;
        public static final List<String> PATTERN_CONSTANTS = ImmutableList.of("^(?:\\^(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\$)$");
        private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
        private static final String regexes = "^(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])\\.\\.(409[0-4]|40[0-8][0-9]|[1-3][0-9]{3}|[1-9][0-9]{1,2}|[1-9])$";
        private final VlanId _vlanId;
        private final VlanRange _vlanRange;
    
    
        public TrunkVlans(VlanId _vlanId) {
            super();
            this._vlanId = Objects.requireNonNull(_vlanId);
            this._vlanRange = null;
        }
        
        public TrunkVlans(VlanRange _vlanRange) {
            super();
            this._vlanRange = Objects.requireNonNull(_vlanRange);
            this._vlanId = null;
        }
        /**
         * Creates a copy from Source Object.
         *
         * @param source Source object
         */
        public TrunkVlans(TrunkVlans source) {
            this._vlanId = source._vlanId;
            this._vlanRange = source._vlanRange;
        }
        
        /**
         * Return a String representing the value of this union.
         *
         * @return String representation of this union's value.
         */
        public String stringValue() {
            if (_vlanId != null) {
                return _vlanId.getValue().toString();
            }
            if (_vlanRange != null) {
                return _vlanRange.getValue().toString();
            }
            throw new IllegalStateException("No value assigned");
        }
    
    
        public VlanId getVlanId() {
            return _vlanId;
        }
        
        public VlanRange getVlanRange() {
            return _vlanRange;
        }
    
    
        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_vlanId);
            result = prime * result + Objects.hashCode(_vlanRange);
            return result;
        }
    
        @Override
        public final boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TrunkVlans)) {
                return false;
            }
            final TrunkVlans other = (TrunkVlans) obj;
            if (!Objects.equals(_vlanId, other._vlanId)) {
                return false;
            }
            if (!Objects.equals(_vlanRange, other._vlanRange)) {
                return false;
            }
            return true;
        }
    
        @Override
        public String toString() {
            final var helper = MoreObjects.toStringHelper(TrunkVlans.class);
            CodeHelpers.appendValue(helper, "vlanId", _vlanId);
            CodeHelpers.appendValue(helper, "vlanRange", _vlanRange);
            return helper.toString();
        }
    }
    


    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-switched-config");

    @Override
    Class<? extends VlanSwitchedConfig> implementedInterface();
    
    /**
     * Return interfaceMode, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Set the interface to access or trunk mode for VLANs
     *     </code>
     * </pre>
     *
     * @return {@code VlanModeType} interfaceMode, or {@code null} if it is not present.
     *
     */
    VlanModeType getInterfaceMode();
    
    /**
     * Return interfaceMode, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Set the interface to access or trunk mode for VLANs
     *     </code>
     * </pre>
     *
     * @return {@code VlanModeType} interfaceMode, guaranteed to be non-null.
     * @throws NoSuchElementException if interfaceMode is not present
     *
     */
    default @NonNull VlanModeType requireInterfaceMode() {
        return CodeHelpers.require(getInterfaceMode(), "interfacemode");
    }
    
    /**
     * Return nativeVlan, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Set the native VLAN id for untagged frames arriving on a trunk interface. Tagged
     *         frames sent on an interface configured with a native VLAN should have their tags
     *         stripped prior to transmission. This configuration is only valid on a trunk
     *         interface.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} nativeVlan, or {@code null} if it is not present.
     *
     */
    VlanId getNativeVlan();
    
    /**
     * Return nativeVlan, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Set the native VLAN id for untagged frames arriving on a trunk interface. Tagged
     *         frames sent on an interface configured with a native VLAN should have their tags
     *         stripped prior to transmission. This configuration is only valid on a trunk
     *         interface.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} nativeVlan, guaranteed to be non-null.
     * @throws NoSuchElementException if nativeVlan is not present
     *
     */
    default @NonNull VlanId requireNativeVlan() {
        return CodeHelpers.require(getNativeVlan(), "nativevlan");
    }
    
    /**
     * Return accessVlan, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Assign the access vlan to the access port.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} accessVlan, or {@code null} if it is not present.
     *
     */
    VlanId getAccessVlan();
    
    /**
     * Return accessVlan, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Assign the access vlan to the access port.
     *     </code>
     * </pre>
     *
     * @return {@code VlanId} accessVlan, guaranteed to be non-null.
     * @throws NoSuchElementException if accessVlan is not present
     *
     */
    default @NonNull VlanId requireAccessVlan() {
        return CodeHelpers.require(getAccessVlan(), "accessvlan");
    }
    
    /**
     * Return trunkVlans, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Specify VLANs, or ranges thereof, that the interface may carry when in trunk
     *         mode. If not specified, all VLANs are allowed on the interface. Ranges are
     *         specified in the form x..y, where x&amp;lt;y - ranges are assumed to be
     *         inclusive (such that the VLAN range is x &amp;lt;= range &amp;lt;= y.
     *     </code>
     * </pre>
     *
     * @return {@code Set<TrunkVlans>} trunkVlans, or {@code null} if it is not present.
     *
     */
    @Nullable Set<TrunkVlans> getTrunkVlans();
    
    /**
     * Return trunkVlans, guaranteed to be non-null.
     *
     * <pre>
     *     <code>
     *         Specify VLANs, or ranges thereof, that the interface may carry when in trunk
     *         mode. If not specified, all VLANs are allowed on the interface. Ranges are
     *         specified in the form x..y, where x&amp;lt;y - ranges are assumed to be
     *         inclusive (such that the VLAN range is x &amp;lt;= range &amp;lt;= y.
     *     </code>
     * </pre>
     *
     * @return {@code Set<TrunkVlans>} trunkVlans, guaranteed to be non-null.
     * @throws NoSuchElementException if trunkVlans is not present
     *
     */
    default @NonNull Set<TrunkVlans> requireTrunkVlans() {
        return CodeHelpers.require(getTrunkVlans(), "trunkvlans");
    }

}

