package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416;
import java.lang.Class;
import java.lang.Override;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.vlan.rev190416.vlan.logical.egress.mapping.top.EgressMapping;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;

/**
 * Egress VLAN stack behaviors for packets that are destined for output via this 
 * subinterface.
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-vlan</b>
 * <pre>
 * grouping vlan-logical-egress-mapping-top {
 *   container egress-mapping {
 *     container config {
 *       uses vlan-logical-egress-mapping-config;
 *     }
 *     container state {
 *       config false;
 *       uses vlan-logical-egress-mapping-config;
 *     }
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface VlanLogicalEgressMappingTop
    extends
    DataObject
{



    /**
     * YANG identifier of the statement represented by this class.
     */
    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("vlan-logical-egress-mapping-top");

    @Override
    Class<? extends VlanLogicalEgressMappingTop> implementedInterface();
    
    /**
     * Return egressMapping, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Egress VLAN and label behaviors for packets that are destined for output via
     *         this subinterface.
     *     </code>
     * </pre>
     *
     * @return {@code EgressMapping} egressMapping, or {@code null} if it is not present.
     *
     */
    EgressMapping getEgressMapping();

}

