package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.yang.binding.DataRoot;

/**
 * This module contains a set of Internet address related types for use in 
 * OpenConfig modules. Portions of this code were derived from IETF RFC 6021. 
 * Please reproduce this note if possible. IETF code is subject to the following 
 * copyright and license: Copyright (c) IETF Trust and the persons identified as 
 * authors of the code. All rights reserved. Redistribution and use in source and 
 * binary forms, with or without modification, is permitted pursuant to, and 
 * subject to the license terms contained in, the Simplified BSD License set forth 
 * in Section 4.c of the IETF Trust's Legal Provisions Relating to IETF Documents 
 * (http://trustee.ietf.org/license-info).
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-inet-types</b>
 * <pre>
 * module openconfig-inet-types {
 *   yang-version 1;
 *   namespace "http://openconfig.net/yang/types/inet";
 *   prefix oc-inet;
 *   import openconfig-extensions {
 *     prefix oc-ext;
 *   }
 *   oc-ext:openconfig-version 0.4.0;
 *   revision 2021-01-07 {
 *   }
 *   revision 2020-10-12 {
 *   }
 *   revision 2020-06-30 {
 *   }
 *   revision 2019-04-25 {
 *   }
 *   revision 2018-11-21 {
 *   }
 *   revision 2017-08-24 {
 *   }
 *   revision 2017-07-06 {
 *   }
 *   revision 2017-04-03 {
 *   }
 *   revision 2017-04-03 {
 *   }
 *   revision 2017-01-26 {
 *   }
 *   oc-ext:catalog-organization openconfig;
 *   oc-ext:origin openconfig;
 *   typedef ipv4-address {
 *     type string {
 *       pattern "(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])";
 *       oc-ext:posix-pattern "^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$";
 *     }
 *   }
 *   typedef ipv4-address-zoned {
 *     type string {
 *       pattern "(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[a-zA-Z0-9_]+)";
 *       oc-ext:posix-pattern "^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[a-zA-Z0-9_]+)$";
 *     }
 *   }
 *   typedef ipv6-address {
 *     type string {
 *       pattern "(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))";
 *       oc-ext:posix-pattern "^(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))$";
 *     }
 *   }
 *   typedef ipv6-address-zoned {
 *     type string {
 *       pattern "^(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))(%[a-zA-Z0-9_]+)$";
 *       oc-ext:posix-pattern "^(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))(%[a-zA-Z0-9_]+)$";
 *     }
 *   }
 *   typedef ipv4-prefix {
 *     type string {
 *       pattern "(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])/(([0-9])|([1-2][0-9])|(3[0-2]))";
 *       oc-ext:posix-pattern "^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])/(([0-9])|([1-2][0-9])|(3[0-2]))$";
 *     }
 *   }
 *   typedef ipv6-prefix {
 *     type string {
 *       pattern "(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])";
 *       oc-ext:posix-pattern "^(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:))/(12[0-8]|1[0-1][0-9]|[1-9][0-9]|[0-9])$";
 *     }
 *   }
 *   typedef ip-address {
 *     type union {
 *       type ipv4-address;
 *       type ipv6-address;
 *     }
 *   }
 *   typedef ip-prefix {
 *     type union {
 *       type ipv4-prefix;
 *       type ipv6-prefix;
 *     }
 *   }
 *   typedef ip-version {
 *     type enumeration {
 *       enum UNKNOWN {
 *         value 0;
 *       }
 *       enum IPV4 {
 *         value 4;
 *       }
 *       enum IPV6 {
 *         value 6;
 *       }
 *     }
 *   }
 *   typedef domain-name {
 *     type string {
 *       length 1..253;
 *       pattern "(((([a-zA-Z0-9_]([a-zA-Z0-9\-_]){0,61})?[a-zA-Z0-9]\.)*([a-zA-Z0-9_]([a-zA-Z0-9\-_]){0,61})?[a-zA-Z0-9]\.?)|\.)";
 *       oc-ext:posix-pattern "^(((([a-zA-Z0-9_]([a-zA-Z0-9\-_]){0,61})?[a-zA-Z0-9]\.)*([a-zA-Z0-9_]([a-zA-Z0-9\-_]){0,61})?[a-zA-Z0-9]\.?)|\.)$";
 *     }
 *   }
 *   typedef host {
 *     type union {
 *       type ip-address;
 *       type domain-name;
 *     }
 *   }
 *   typedef as-number {
 *     type uint32;
 *   }
 *   typedef dscp {
 *     type uint8 {
 *       range 0..63;
 *     }
 *   }
 *   typedef ipv6-flow-label {
 *     type uint32 {
 *       range 0..1048575;
 *     }
 *   }
 *   typedef port-number {
 *     type uint16;
 *   }
 *   typedef uri {
 *     type string;
 *   }
 *   typedef url {
 *     type string;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public interface OpenconfigInetTypesData
    extends
    DataRoot
{





}

