package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.types.inet.rev210107;
import com.google.common.base.MoreObjects;
import java.io.Serializable;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import javax.management.ConstructorParameters;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.ScalarTypeObject;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openconfig-inet-types</b>
 * <pre>
 * typedef ipv6-flow-label {
 *   type uint32 {
 *     range 0..1048575;
 *   }
 * }
 * </pre>
 *
 */
@Generated("mdsal-binding-generator")
public class Ipv6FlowLabel
 implements ScalarTypeObject<Uint32>, Serializable {
    @java.io.Serial
    private static final long serialVersionUID = -7589288865525379836L;
    private final Uint32 _value;

    private static void check_valueRange(final long value) {
        if (value <= 1048575L) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..1048575]]", value);
    }

    @ConstructorParameters("value")
    public Ipv6FlowLabel(Uint32 _value) {
        if (_value != null) {
            check_valueRange(_value.longValue());
        }
        
        CodeHelpers.requireValue(_value);
    
        this._value = _value;
    }
    
    /**
     * Creates a copy from Source Object.
     *
     * @param source Source object
     */
    public Ipv6FlowLabel(Ipv6FlowLabel source) {
        this._value = source._value;
    }

    public static Ipv6FlowLabel getDefaultInstance(final String defaultValue) {
        return new Ipv6FlowLabel(Uint32.valueOf(defaultValue));
    }

    @Override
    public Uint32 getValue() {
        return _value;
    }


    @Override
    public int hashCode() {
        return CodeHelpers.wrapperHashCode(_value);
    }

    @Override
    public final boolean equals(java.lang.Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Ipv6FlowLabel)) {
            return false;
        }
        final Ipv6FlowLabel other = (Ipv6FlowLabel) obj;
        if (!Objects.equals(_value, other._value)) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        final var helper = MoreObjects.toStringHelper(Ipv6FlowLabel.class);
        CodeHelpers.appendValue(helper, "value", _value);
        return helper.toString();
    }
}

