package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.AaaTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.aaa.rev200730.aaa.top.Aaa;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.AlarmsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.alarms.rev190709.alarms.top.Alarms;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.LicenseTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.license.rev200422.license.top.License;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.MessagesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.messages.rev180813.messages.top.Messages;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.LoggingTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.logging.rev181121.logging.top.Logging;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.ProcmonProcessesTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.procmon.rev190315.procmon.processes.top.Processes;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemClockTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemCpuTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemDnsTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemMemoryTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.clock.top.Clock;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.cpu.top.Cpus;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.dns.top.Dns;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.memory.top.Memory;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.top.Ntp;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.Config;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.top.system.State;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemSshServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.SystemTelnetServerTop;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.ssh.server.top.SshServer;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.terminal.rev181121.system.telnet.server.top.TelnetServer;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link System} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     System createSystem(int fooXyzzy, int barBaz) {
 *         return new SystemBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of System, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see System
 *
 */
@Generated("mdsal-binding-generator")
public class SystemBuilder {

    private Aaa _aaa;
    private Alarms _alarms;
    private Clock _clock;
    private Config _config;
    private Cpus _cpus;
    private Dns _dns;
    private License _license;
    private Logging _logging;
    private Memory _memory;
    private Messages _messages;
    private Ntp _ntp;
    private Processes _processes;
    private SshServer _sshServer;
    private State _state;
    private TelnetServer _telnetServer;


    Map<Class<? extends Augmentation<System>>, Augmentation<System>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public SystemBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link SystemClockTop}.
     *
     * @param arg SystemClockTop from which the builder should be initialized
     */
    public SystemBuilder(SystemClockTop arg) {
        this._clock = arg.getClock();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link SystemDnsTop}.
     *
     * @param arg SystemDnsTop from which the builder should be initialized
     */
    public SystemBuilder(SystemDnsTop arg) {
        this._dns = arg.getDns();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link SystemNtpTop}.
     *
     * @param arg SystemNtpTop from which the builder should be initialized
     */
    public SystemBuilder(SystemNtpTop arg) {
        this._ntp = arg.getNtp();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link SystemSshServerTop}.
     *
     * @param arg SystemSshServerTop from which the builder should be initialized
     */
    public SystemBuilder(SystemSshServerTop arg) {
        this._sshServer = arg.getSshServer();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link SystemTelnetServerTop}.
     *
     * @param arg SystemTelnetServerTop from which the builder should be initialized
     */
    public SystemBuilder(SystemTelnetServerTop arg) {
        this._telnetServer = arg.getTelnetServer();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link LoggingTop}.
     *
     * @param arg LoggingTop from which the builder should be initialized
     */
    public SystemBuilder(LoggingTop arg) {
        this._logging = arg.getLogging();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link AaaTop}.
     *
     * @param arg AaaTop from which the builder should be initialized
     */
    public SystemBuilder(AaaTop arg) {
        this._aaa = arg.getAaa();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link SystemMemoryTop}.
     *
     * @param arg SystemMemoryTop from which the builder should be initialized
     */
    public SystemBuilder(SystemMemoryTop arg) {
        this._memory = arg.getMemory();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link SystemCpuTop}.
     *
     * @param arg SystemCpuTop from which the builder should be initialized
     */
    public SystemBuilder(SystemCpuTop arg) {
        this._cpus = arg.getCpus();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link ProcmonProcessesTop}.
     *
     * @param arg ProcmonProcessesTop from which the builder should be initialized
     */
    public SystemBuilder(ProcmonProcessesTop arg) {
        this._processes = arg.getProcesses();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link AlarmsTop}.
     *
     * @param arg AlarmsTop from which the builder should be initialized
     */
    public SystemBuilder(AlarmsTop arg) {
        this._alarms = arg.getAlarms();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link MessagesTop}.
     *
     * @param arg MessagesTop from which the builder should be initialized
     */
    public SystemBuilder(MessagesTop arg) {
        this._messages = arg.getMessages();
    }
    
    
    /**
     * Construct a new builder initialized from specified {@link LicenseTop}.
     *
     * @param arg LicenseTop from which the builder should be initialized
     */
    public SystemBuilder(LicenseTop arg) {
        this._license = arg.getLicense();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link System}.
     *
     * @param base System from which the builder should be initialized
     */
    public SystemBuilder(System base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._aaa = base.getAaa();
        this._alarms = base.getAlarms();
        this._clock = base.getClock();
        this._config = base.getConfig();
        this._cpus = base.getCpus();
        this._dns = base.getDns();
        this._license = base.getLicense();
        this._logging = base.getLogging();
        this._memory = base.getMemory();
        this._messages = base.getMessages();
        this._ntp = base.getNtp();
        this._processes = base.getProcesses();
        this._sshServer = base.getSshServer();
        this._state = base.getState();
        this._telnetServer = base.getTelnetServer();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SystemSshServerTop}</li>
     *   <li>{@link MessagesTop}</li>
     *   <li>{@link SystemDnsTop}</li>
     *   <li>{@link SystemMemoryTop}</li>
     *   <li>{@link SystemCpuTop}</li>
     *   <li>{@link LoggingTop}</li>
     *   <li>{@link SystemTelnetServerTop}</li>
     *   <li>{@link AlarmsTop}</li>
     *   <li>{@link ProcmonProcessesTop}</li>
     *   <li>{@link SystemClockTop}</li>
     *   <li>{@link SystemNtpTop}</li>
     *   <li>{@link AaaTop}</li>
     *   <li>{@link LicenseTop}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemSshServerTop castArg) {
            this._sshServer = castArg.getSshServer();
            isValidArg = true;
        }
        if (arg instanceof MessagesTop castArg) {
            this._messages = castArg.getMessages();
            isValidArg = true;
        }
        if (arg instanceof SystemDnsTop castArg) {
            this._dns = castArg.getDns();
            isValidArg = true;
        }
        if (arg instanceof SystemMemoryTop castArg) {
            this._memory = castArg.getMemory();
            isValidArg = true;
        }
        if (arg instanceof SystemCpuTop castArg) {
            this._cpus = castArg.getCpus();
            isValidArg = true;
        }
        if (arg instanceof LoggingTop castArg) {
            this._logging = castArg.getLogging();
            isValidArg = true;
        }
        if (arg instanceof SystemTelnetServerTop castArg) {
            this._telnetServer = castArg.getTelnetServer();
            isValidArg = true;
        }
        if (arg instanceof AlarmsTop castArg) {
            this._alarms = castArg.getAlarms();
            isValidArg = true;
        }
        if (arg instanceof ProcmonProcessesTop castArg) {
            this._processes = castArg.getProcesses();
            isValidArg = true;
        }
        if (arg instanceof SystemClockTop castArg) {
            this._clock = castArg.getClock();
            isValidArg = true;
        }
        if (arg instanceof SystemNtpTop castArg) {
            this._ntp = castArg.getNtp();
            isValidArg = true;
        }
        if (arg instanceof AaaTop castArg) {
            this._aaa = castArg.getAaa();
            isValidArg = true;
        }
        if (arg instanceof LicenseTop castArg) {
            this._license = castArg.getLicense();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemSshServerTop, MessagesTop, SystemDnsTop, SystemMemoryTop, SystemCpuTop, LoggingTop, SystemTelnetServerTop, AlarmsTop, ProcmonProcessesTop, SystemClockTop, SystemNtpTop, AaaTop, LicenseTop]");
    }

    /**
     * Return current value associated with the property corresponding to {@link System#getAaa()}.
     *
     * @return current value
     */
    public Aaa getAaa() {
        return _aaa;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getAlarms()}.
     *
     * @return current value
     */
    public Alarms getAlarms() {
        return _alarms;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getClock()}.
     *
     * @return current value
     */
    public Clock getClock() {
        return _clock;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getConfig()}.
     *
     * @return current value
     */
    public Config getConfig() {
        return _config;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getCpus()}.
     *
     * @return current value
     */
    public Cpus getCpus() {
        return _cpus;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getDns()}.
     *
     * @return current value
     */
    public Dns getDns() {
        return _dns;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getLicense()}.
     *
     * @return current value
     */
    public License getLicense() {
        return _license;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getLogging()}.
     *
     * @return current value
     */
    public Logging getLogging() {
        return _logging;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getMemory()}.
     *
     * @return current value
     */
    public Memory getMemory() {
        return _memory;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getMessages()}.
     *
     * @return current value
     */
    public Messages getMessages() {
        return _messages;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getNtp()}.
     *
     * @return current value
     */
    public Ntp getNtp() {
        return _ntp;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getProcesses()}.
     *
     * @return current value
     */
    public Processes getProcesses() {
        return _processes;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getSshServer()}.
     *
     * @return current value
     */
    public SshServer getSshServer() {
        return _sshServer;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getState()}.
     *
     * @return current value
     */
    public State getState() {
        return _state;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link System#getTelnetServer()}.
     *
     * @return current value
     */
    public TelnetServer getTelnetServer() {
        return _telnetServer;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<System>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link System#getAaa()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setAaa(final Aaa value) {
        this._aaa = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getAlarms()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setAlarms(final Alarms value) {
        this._alarms = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getClock()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setClock(final Clock value) {
        this._clock = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getConfig()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setConfig(final Config value) {
        this._config = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getCpus()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setCpus(final Cpus value) {
        this._cpus = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getDns()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setDns(final Dns value) {
        this._dns = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getLicense()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setLicense(final License value) {
        this._license = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getLogging()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setLogging(final Logging value) {
        this._logging = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getMemory()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setMemory(final Memory value) {
        this._memory = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getMessages()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setMessages(final Messages value) {
        this._messages = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getNtp()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setNtp(final Ntp value) {
        this._ntp = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getProcesses()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setProcesses(final Processes value) {
        this._processes = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getSshServer()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setSshServer(final SshServer value) {
        this._sshServer = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getState()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setState(final State value) {
        this._state = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link System#getTelnetServer()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public SystemBuilder setTelnetServer(final TelnetServer value) {
        this._telnetServer = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public SystemBuilder addAugmentation(Augmentation<System> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public SystemBuilder removeAugmentation(Class<? extends Augmentation<System>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link System} instance.
     *
     * @return A new {@link System} instance.
     */
    public @NonNull System build() {
        return new SystemImpl(this);
    }

    private static final class SystemImpl
        extends AbstractAugmentable<System>
        implements System {
    
        private final Aaa _aaa;
        private final Alarms _alarms;
        private final Clock _clock;
        private final Config _config;
        private final Cpus _cpus;
        private final Dns _dns;
        private final License _license;
        private final Logging _logging;
        private final Memory _memory;
        private final Messages _messages;
        private final Ntp _ntp;
        private final Processes _processes;
        private final SshServer _sshServer;
        private final State _state;
        private final TelnetServer _telnetServer;
    
        SystemImpl(SystemBuilder base) {
            super(base.augmentation);
            this._aaa = base.getAaa();
            this._alarms = base.getAlarms();
            this._clock = base.getClock();
            this._config = base.getConfig();
            this._cpus = base.getCpus();
            this._dns = base.getDns();
            this._license = base.getLicense();
            this._logging = base.getLogging();
            this._memory = base.getMemory();
            this._messages = base.getMessages();
            this._ntp = base.getNtp();
            this._processes = base.getProcesses();
            this._sshServer = base.getSshServer();
            this._state = base.getState();
            this._telnetServer = base.getTelnetServer();
        }
    
        @Override
        public Aaa getAaa() {
            return _aaa;
        }
        
        @Override
        public Alarms getAlarms() {
            return _alarms;
        }
        
        @Override
        public Clock getClock() {
            return _clock;
        }
        
        @Override
        public Config getConfig() {
            return _config;
        }
        
        @Override
        public Cpus getCpus() {
            return _cpus;
        }
        
        @Override
        public Dns getDns() {
            return _dns;
        }
        
        @Override
        public License getLicense() {
            return _license;
        }
        
        @Override
        public Logging getLogging() {
            return _logging;
        }
        
        @Override
        public Memory getMemory() {
            return _memory;
        }
        
        @Override
        public Messages getMessages() {
            return _messages;
        }
        
        @Override
        public Ntp getNtp() {
            return _ntp;
        }
        
        @Override
        public Processes getProcesses() {
            return _processes;
        }
        
        @Override
        public SshServer getSshServer() {
            return _sshServer;
        }
        
        @Override
        public State getState() {
            return _state;
        }
        
        @Override
        public TelnetServer getTelnetServer() {
            return _telnetServer;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = System.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return System.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return System.bindingToString(this);
        }
    }
}
