package org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.system.ntp.auth.keys.top.ntp.keys.ntp.key;
import java.lang.Class;
import java.lang.IllegalArgumentException;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.NTPAUTHTYPE;
import org.opendaylight.yang.gen.v1.http.openconfig.net.yang.system.rev200413.SystemNtpAuthKeysConfig;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 * Class that builds {@link Config} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     Config createConfig(int fooXyzzy, int barBaz) {
 *         return new ConfigBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of Config, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization opportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see Config
 *
 */
@Generated("mdsal-binding-generator")
public class ConfigBuilder {

    private Uint16 _keyId;
    private NTPAUTHTYPE _keyType;
    private String _keyValue;


    Map<Class<? extends Augmentation<Config>>, Augmentation<Config>> augmentation = Map.of();

    /**
     * Construct an empty builder.
     */
    public ConfigBuilder() {
        // No-op
    }

    
    
    /**
     * Construct a new builder initialized from specified {@link SystemNtpAuthKeysConfig}.
     *
     * @param arg SystemNtpAuthKeysConfig from which the builder should be initialized
     */
    public ConfigBuilder(SystemNtpAuthKeysConfig arg) {
        this._keyId = arg.getKeyId();
        this._keyType = arg.getKeyType();
        this._keyValue = arg.getKeyValue();
    }
    

    /**
     * Construct a builder initialized with state from specified {@link Config}.
     *
     * @param base Config from which the builder should be initialized
     */
    public ConfigBuilder(Config base) {
        final var aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._keyId = base.getKeyId();
        this._keyType = base.getKeyType();
        this._keyValue = base.getKeyValue();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     *   <li>{@link SystemNtpAuthKeysConfig}</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SystemNtpAuthKeysConfig castArg) {
            this._keyId = castArg.getKeyId();
            this._keyType = castArg.getKeyType();
            this._keyValue = castArg.getKeyValue();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[SystemNtpAuthKeysConfig]");
    }

    /**
     * Return current value associated with the property corresponding to {@link Config#getKeyId()}.
     *
     * @return current value
     */
    public Uint16 getKeyId() {
        return _keyId;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getKeyType()}.
     *
     * @return current value
     */
    public NTPAUTHTYPE getKeyType() {
        return _keyType;
    }
    
    /**
     * Return current value associated with the property corresponding to {@link Config#getKeyValue()}.
     *
     * @return current value
     */
    public String getKeyValue() {
        return _keyValue;
    }

    /**
     * Return the specified augmentation, if it is present in this builder.
     *
     * @param <E$$> augmentation type
     * @param augmentationType augmentation type class
     * @return Augmentation object from this builder, or {@code null} if not present
     * @throws NullPointerException if {@code augmentType} is {@code null}
     */
    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<Config>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    /**
     * Set the property corresponding to {@link Config#getKeyId()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setKeyId(final Uint16 value) {
        this._keyId = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getKeyType()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setKeyType(final NTPAUTHTYPE value) {
        this._keyType = value;
        return this;
    }
    
    /**
     * Set the property corresponding to {@link Config#getKeyValue()} to the specified
     * value.
     *
     * @param value desired value
     * @return this builder
     */
    public ConfigBuilder setKeyValue(final String value) {
        this._keyValue = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public ConfigBuilder addAugmentation(Augmentation<Config> augmentation) {
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentation.implementedInterface(), augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public ConfigBuilder removeAugmentation(Class<? extends Augmentation<Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    /**
     * A new {@link Config} instance.
     *
     * @return A new {@link Config} instance.
     */
    public @NonNull Config build() {
        return new ConfigImpl(this);
    }

    private static final class ConfigImpl
        extends AbstractAugmentable<Config>
        implements Config {
    
        private final Uint16 _keyId;
        private final NTPAUTHTYPE _keyType;
        private final String _keyValue;
    
        ConfigImpl(ConfigBuilder base) {
            super(base.augmentation);
            this._keyId = base.getKeyId();
            this._keyType = base.getKeyType();
            this._keyValue = base.getKeyValue();
        }
    
        @Override
        public Uint16 getKeyId() {
            return _keyId;
        }
        
        @Override
        public NTPAUTHTYPE getKeyType() {
            return _keyType;
        }
        
        @Override
        public String getKeyValue() {
            return _keyValue;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = Config.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return Config.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return Config.bindingToString(this);
        }
    }
}
